/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeatureFinder;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="feature", name="repo-add", description="Add a features repository")
public class RepoAddCommand
extends AbstractAction {
    @Argument(index=0, name="name/url", description="Shortcut name of the features repository or the full URL", required=true, multiValued=false)
    private String nameOrUrl;
    @Argument(index=1, name="version", description="The version of the features repository if using features repository name as first argument. It should be empty if using the URL", required=false, multiValued=false)
    private String version;
    @Option(name="-i", aliases={"--install"}, description="Install all features contained in the features repository", required=false, multiValued=false)
    private boolean install;
    private FeatureFinder featureFinder;
    private FeaturesService featuresService;

    public void setFeatureFinder(FeatureFinder featureFinder) {
        this.featureFinder = featureFinder;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    protected Object doExecute() throws Exception {
        URI uri = this.featureFinder.getUriFor(this.nameOrUrl, this.version);
        if (uri == null) {
            uri = new URI(this.nameOrUrl);
        }
        System.out.println("Adding feature url " + uri);
        this.featuresService.addRepository(uri, this.install);
        return null;
    }
}

