/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.license.FullTextMatchingLicense;
import org.apache.rat.api.Document;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class FullTextLicenseMatcher
extends FullTextMatchingLicense {
    private boolean validated = false;
    private String fullText = "";
    private Project project;

    public void setProject(Project project) {
        this.project = project;
    }

    public void addText(String text) {
        if (text != null && text.trim().length() > 0) {
            this.fullText = this.fullText + this.project.replaceProperties(text);
            this.setFullText(this.fullText);
        }
    }

    public boolean match(Document subject, String line) throws RatHeaderAnalysisException {
        this.validate();
        return super.match(subject, line);
    }

    private void validate() {
        if (!this.validated) {
            this.validated = true;
            if (!this.hasFullText()) {
                throw new BuildException("You must specify the text to match.");
            }
            if (this.getLicenseFamilyCategory() == null) {
                throw new BuildException("The licenseFamilyCategory attribute is required.");
            }
            if (this.getLicenseFamilyName() == null) {
                throw new BuildException("The licenseFamilyName attribute is required.");
            }
        }
    }
}

