﻿// Lucene version compatibility level 4.8.1
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

using Lucene.Net.Support;

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class PorterStemmer : SnowballProgram
    {
        // LUCENENET specific: Factored out methodObject by using Func<bool> instead of Reflection

        private readonly static Among[] a_0 = {
                    new Among ( "s", -1, 3 ),
                    new Among ( "ies", 0, 2 ),
                    new Among ( "sses", 0, 1 ),
                    new Among ( "ss", 0, -1 )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "", -1, 3 ),
                    new Among ( "bb", 0, 2 ),
                    new Among ( "dd", 0, 2 ),
                    new Among ( "ff", 0, 2 ),
                    new Among ( "gg", 0, 2 ),
                    new Among ( "bl", 0, 1 ),
                    new Among ( "mm", 0, 2 ),
                    new Among ( "nn", 0, 2 ),
                    new Among ( "pp", 0, 2 ),
                    new Among ( "rr", 0, 2 ),
                    new Among ( "at", 0, 1 ),
                    new Among ( "tt", 0, 2 ),
                    new Among ( "iz", 0, 1 )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "ed", -1, 2 ),
                    new Among ( "eed", 0, 1 ),
                    new Among ( "ing", -1, 2 )
                };

        private readonly static Among[] a_3 = {
                    new Among ( "anci", -1, 3 ),
                    new Among ( "enci", -1, 2 ),
                    new Among ( "abli", -1, 4 ),
                    new Among ( "eli", -1, 6 ),
                    new Among ( "alli", -1, 9 ),
                    new Among ( "ousli", -1, 12 ),
                    new Among ( "entli", -1, 5 ),
                    new Among ( "aliti", -1, 10 ),
                    new Among ( "biliti", -1, 14 ),
                    new Among ( "iviti", -1, 13 ),
                    new Among ( "tional", -1, 1 ),
                    new Among ( "ational", 10, 8 ),
                    new Among ( "alism", -1, 10 ),
                    new Among ( "ation", -1, 8 ),
                    new Among ( "ization", 13, 7 ),
                    new Among ( "izer", -1, 7 ),
                    new Among ( "ator", -1, 8 ),
                    new Among ( "iveness", -1, 13 ),
                    new Among ( "fulness", -1, 11 ),
                    new Among ( "ousness", -1, 12 )
                };

        private readonly static Among[] a_4 = {
                    new Among ( "icate", -1, 2 ),
                    new Among ( "ative", -1, 3 ),
                    new Among ( "alize", -1, 1 ),
                    new Among ( "iciti", -1, 2 ),
                    new Among ( "ical", -1, 2 ),
                    new Among ( "ful", -1, 3 ),
                    new Among ( "ness", -1, 3 )
                };

        private readonly static Among[] a_5 = {
                    new Among ( "ic", -1, 1 ),
                    new Among ( "ance", -1, 1 ),
                    new Among ( "ence", -1, 1 ),
                    new Among ( "able", -1, 1 ),
                    new Among ( "ible", -1, 1 ),
                    new Among ( "ate", -1, 1 ),
                    new Among ( "ive", -1, 1 ),
                    new Among ( "ize", -1, 1 ),
                    new Among ( "iti", -1, 1 ),
                    new Among ( "al", -1, 1 ),
                    new Among ( "ism", -1, 1 ),
                    new Among ( "ion", -1, 2 ),
                    new Among ( "er", -1, 1 ),
                    new Among ( "ous", -1, 1 ),
                    new Among ( "ant", -1, 1 ),
                    new Among ( "ent", -1, 1 ),
                    new Among ( "ment", 15, 1 ),
                    new Among ( "ement", 16, 1 ),
                    new Among ( "ou", -1, 1 )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16, (char)1 };

        private static readonly char[] g_v_WXY = { (char)1, (char)17, (char)65, (char)208, (char)1 };

        private bool B_Y_found;
        private int I_p2;
        private int I_p1;

        private void copy_from(PorterStemmer other)
        {
            B_Y_found = other.B_Y_found;
            I_p2 = other.I_p2;
            I_p1 = other.I_p1;
            base.CopyFrom(other);
        }

        [ExceptionToNetNumericConvention]
        private bool r_shortv()
        {
            // (, line 19
            if (!(OutGroupingB(g_v_WXY, 89, 121)))
            {
                return false;
            }
            if (!(InGroupingB(g_v, 97, 121)))
            {
                return false;
            }
            if (!(OutGroupingB(g_v, 97, 121)))
            {
                return false;
            }
            return true;
        }

        private bool r_R1()
        {
            if (!(I_p1 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R2()
        {
            if (!(I_p2 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_Step_1a()
        {
            int among_var;
            // (, line 24
            // [, line 25
            m_ket = m_cursor;
            // substring, line 25
            among_var = FindAmongB(a_0, 4);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 25
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 26
                    // <-, line 26
                    SliceFrom("ss");
                    break;
                case 2:
                    // (, line 27
                    // <-, line 27
                    SliceFrom("i");
                    break;
                case 3:
                    // (, line 29
                    // delete, line 29
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_Step_1b()
        {
            int among_var;
            int v_1;
            int v_3;
            int v_4;
            // (, line 33
            // [, line 34
            m_ket = m_cursor;
            // substring, line 34
            among_var = FindAmongB(a_2, 3);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 34
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 35
                    // call R1, line 35
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 35
                    SliceFrom("ee");
                    break;
                case 2:
                    // (, line 37
                    // test, line 38
                    v_1 = m_limit - m_cursor;
                    // gopast, line 38
                    while (true)
                    {
                        do
                        {
                            if (!(InGroupingB(g_v, 97, 121)))
                            {
                                goto lab1;
                            }
                            goto golab0;
                        } while (false);
                        lab1:
                        if (m_cursor <= m_limit_backward)
                        {
                            return false;
                        }
                        m_cursor--;
                    }
                    golab0:
                    m_cursor = m_limit - v_1;
                    // delete, line 38
                    SliceDel();
                    // test, line 39
                    v_3 = m_limit - m_cursor;
                    // substring, line 39
                    among_var = FindAmongB(a_1, 13);
                    if (among_var == 0)
                    {
                        return false;
                    }
                    m_cursor = m_limit - v_3;
                    switch (among_var)
                    {
                        case 0:
                            return false;
                        case 1:
                            // (, line 41
                            // <+, line 41
                            {
                                int c = m_cursor;
                                Insert(m_cursor, m_cursor, "e");
                                m_cursor = c;
                            }
                            break;
                        case 2:
                            // (, line 44
                            // [, line 44
                            m_ket = m_cursor;
                            // next, line 44
                            if (m_cursor <= m_limit_backward)
                            {
                                return false;
                            }
                            m_cursor--;
                            // ], line 44
                            m_bra = m_cursor;
                            // delete, line 44
                            SliceDel();
                            break;
                        case 3:
                            // (, line 45
                            // atmark, line 45
                            if (m_cursor != I_p1)
                            {
                                return false;
                            }
                            // test, line 45
                            v_4 = m_limit - m_cursor;
                            // call shortv, line 45
                            if (!r_shortv())
                            {
                                return false;
                            }
                            m_cursor = m_limit - v_4;
                            // <+, line 45
                            {
                                int c = m_cursor;
                                Insert(m_cursor, m_cursor, "e");
                                m_cursor = c;
                            }
                            break;
                    }
                    break;
            }
            return true;
        }

        private bool r_Step_1c()
        {
            int v_1;
            // (, line 51
            // [, line 52
            m_ket = m_cursor;
            // or, line 52
            do
            {
                v_1 = m_limit - m_cursor;
                do
                {
                    // literal, line 52
                    if (!(Eq_S_B(1, "y")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_1;
                // literal, line 52
                if (!(Eq_S_B(1, "Y")))
                {
                    return false;
                }
            } while (false);
            lab0:
            // ], line 52
            m_bra = m_cursor;
            // gopast, line 53
            while (true)
            {
                do
                {
                    if (!(InGroupingB(g_v, 97, 121)))
                    {
                        goto lab3;
                    }
                    goto golab2;
                } while (false);
                lab3:
                if (m_cursor <= m_limit_backward)
                {
                    return false;
                }
                m_cursor--;
            }
            golab2:
            // <-, line 54
            SliceFrom("i");
            return true;
        }

        private bool r_Step_2()
        {
            int among_var;
            // (, line 57
            // [, line 58
            m_ket = m_cursor;
            // substring, line 58
            among_var = FindAmongB(a_3, 20);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 58
            m_bra = m_cursor;
            // call R1, line 58
            if (!r_R1())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 59
                    // <-, line 59
                    SliceFrom("tion");
                    break;
                case 2:
                    // (, line 60
                    // <-, line 60
                    SliceFrom("ence");
                    break;
                case 3:
                    // (, line 61
                    // <-, line 61
                    SliceFrom("ance");
                    break;
                case 4:
                    // (, line 62
                    // <-, line 62
                    SliceFrom("able");
                    break;
                case 5:
                    // (, line 63
                    // <-, line 63
                    SliceFrom("ent");
                    break;
                case 6:
                    // (, line 64
                    // <-, line 64
                    SliceFrom("e");
                    break;
                case 7:
                    // (, line 66
                    // <-, line 66
                    SliceFrom("ize");
                    break;
                case 8:
                    // (, line 68
                    // <-, line 68
                    SliceFrom("ate");
                    break;
                case 9:
                    // (, line 69
                    // <-, line 69
                    SliceFrom("al");
                    break;
                case 10:
                    // (, line 71
                    // <-, line 71
                    SliceFrom("al");
                    break;
                case 11:
                    // (, line 72
                    // <-, line 72
                    SliceFrom("ful");
                    break;
                case 12:
                    // (, line 74
                    // <-, line 74
                    SliceFrom("ous");
                    break;
                case 13:
                    // (, line 76
                    // <-, line 76
                    SliceFrom("ive");
                    break;
                case 14:
                    // (, line 77
                    // <-, line 77
                    SliceFrom("ble");
                    break;
            }
            return true;
        }

        private bool r_Step_3()
        {
            int among_var;
            // (, line 81
            // [, line 82
            m_ket = m_cursor;
            // substring, line 82
            among_var = FindAmongB(a_4, 7);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 82
            m_bra = m_cursor;
            // call R1, line 82
            if (!r_R1())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 83
                    // <-, line 83
                    SliceFrom("al");
                    break;
                case 2:
                    // (, line 85
                    // <-, line 85
                    SliceFrom("ic");
                    break;
                case 3:
                    // (, line 87
                    // delete, line 87
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_Step_4()
        {
            int among_var;
            int v_1;
            // (, line 91
            // [, line 92
            m_ket = m_cursor;
            // substring, line 92
            among_var = FindAmongB(a_5, 19);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 92
            m_bra = m_cursor;
            // call R2, line 92
            if (!r_R2())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 95
                    // delete, line 95
                    SliceDel();
                    break;
                case 2:
                    // (, line 96
                    // or, line 96
                    do
                    {
                        v_1 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 96
                            if (!(Eq_S_B(1, "s")))
                            {
                                goto lab1;
                            }
                            goto lab0;
                        } while (false);
                        lab1:
                        m_cursor = m_limit - v_1;
                        // literal, line 96
                        if (!(Eq_S_B(1, "t")))
                        {
                            return false;
                        }
                    } while (false);
                    lab0:
                    // delete, line 96
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_Step_5a()
        {
            int v_1;
            int v_2;
            // (, line 100
            // [, line 101
            m_ket = m_cursor;
            // literal, line 101
            if (!(Eq_S_B(1, "e")))
            {
                return false;
            }
            // ], line 101
            m_bra = m_cursor;
            // or, line 102
            do
            {
                v_1 = m_limit - m_cursor;
                do
                {
                    // call R2, line 102
                    if (!r_R2())
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_1;
                // (, line 102
                // call R1, line 102
                if (!r_R1())
                {
                    return false;
                }
                // not, line 102
                {
                    v_2 = m_limit - m_cursor;
                    do
                    {
                        // call shortv, line 102
                        if (!r_shortv())
                        {
                            goto lab2;
                        }
                        return false;
                    } while (false);
                    lab2:
                    m_cursor = m_limit - v_2;
                }
            } while (false);
            lab0:
            // delete, line 103
            SliceDel();
            return true;
        }

        private bool r_Step_5b()
        {
            // (, line 106
            // [, line 107
            m_ket = m_cursor;
            // literal, line 107
            if (!(Eq_S_B(1, "l")))
            {
                return false;
            }
            // ], line 107
            m_bra = m_cursor;
            // call R2, line 108
            if (!r_R2())
            {
                return false;
            }
            // literal, line 108
            if (!(Eq_S_B(1, "l")))
            {
                return false;
            }
            // delete, line 109
            SliceDel();
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_10;
            int v_11;
            int v_12;
            int v_13;
            int v_14;
            int v_15;
            int v_16;
            int v_17;
            int v_18;
            int v_19;
            int v_20;
            // (, line 113
            // unset Y_found, line 115
            B_Y_found = false;
            // do, line 116
            v_1 = m_cursor;
            do
            {
                // (, line 116
                // [, line 116
                m_bra = m_cursor;
                // literal, line 116
                if (!(Eq_S(1, "y")))
                {
                    goto lab0;
                }
                // ], line 116
                m_ket = m_cursor;
                // <-, line 116
                SliceFrom("Y");
                // set Y_found, line 116
                B_Y_found = true;
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 117
            v_2 = m_cursor;
            do
            {
                // repeat, line 117
                while (true)
                {
                    v_3 = m_cursor;
                    do
                    {
                        // (, line 117
                        // goto, line 117
                        while (true)
                        {
                            v_4 = m_cursor;
                            do
                            {
                                // (, line 117
                                if (!(InGrouping(g_v, 97, 121)))
                                {
                                    goto lab5;
                                }
                                // [, line 117
                                m_bra = m_cursor;
                                // literal, line 117
                                if (!(Eq_S(1, "y")))
                                {
                                    goto lab5;
                                }
                                // ], line 117
                                m_ket = m_cursor;
                                m_cursor = v_4;
                                goto golab4;
                            } while (false);
                            lab5:
                            m_cursor = v_4;
                            if (m_cursor >= m_limit)
                            {
                                goto lab3;
                            }
                            m_cursor++;
                        }
                        golab4:
                        // <-, line 117
                        SliceFrom("Y");
                        // set Y_found, line 117
                        B_Y_found = true;
                        // LUCENENET NOTE: continue label is not supported directly in .NET,
                        // so we just need to add another goto to get to the end of the outer loop.
                        // See: http://stackoverflow.com/a/359449/181087

                        // Original code:
                        //continue replab2;

                        goto end_of_outer_loop;

                    } while (false);
                    lab3:
                    m_cursor = v_3;
                    goto replab2;
                    end_of_outer_loop: { }
                }
                replab2:;
            } while (false);
            //lab1: // not referenced
            m_cursor = v_2;
            I_p1 = m_limit;
            I_p2 = m_limit;
            // do, line 121
            v_5 = m_cursor;
            do
            {
                // (, line 121
                // gopast, line 122
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 97, 121)))
                        {
                            goto lab8;
                        }
                        goto golab7;
                    } while (false);
                    lab8:
                    if (m_cursor >= m_limit)
                    {
                        goto lab6;
                    }
                    m_cursor++;
                }
                golab7:
                // gopast, line 122
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 121)))
                        {
                            goto lab10;
                        }
                        goto golab9;
                    } while (false);
                    lab10:
                    if (m_cursor >= m_limit)
                    {
                        goto lab6;
                    }
                    m_cursor++;
                }
                golab9:
                // setmark p1, line 122
                I_p1 = m_cursor;
                // gopast, line 123
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 97, 121)))
                        {
                            goto lab12;
                        }
                        goto golab11;
                    } while (false);
                    lab12:
                    if (m_cursor >= m_limit)
                    {
                        goto lab6;
                    }
                    m_cursor++;
                }
                golab11:
                // gopast, line 123
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 121)))
                        {
                            goto lab14;
                        }
                        goto golab13;
                    } while (false);
                    lab14:
                    if (m_cursor >= m_limit)
                    {
                        goto lab6;
                    }
                    m_cursor++;
                }
                golab13:
                // setmark p2, line 123
                I_p2 = m_cursor;
            } while (false);
            lab6:
            m_cursor = v_5;
            // backwards, line 126
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 126
            // do, line 127
            v_10 = m_limit - m_cursor;
            do
            {
                // call Step_1a, line 127
                if (!r_Step_1a())
                {
                    goto lab15;
                }
            } while (false);
            lab15:
            m_cursor = m_limit - v_10;
            // do, line 128
            v_11 = m_limit - m_cursor;
            do
            {
                // call Step_1b, line 128
                if (!r_Step_1b())
                {
                    goto lab16;
                }
            } while (false);
            lab16:
            m_cursor = m_limit - v_11;
            // do, line 129
            v_12 = m_limit - m_cursor;
            do
            {
                // call Step_1c, line 129
                if (!r_Step_1c())
                {
                    goto lab17;
                }
            } while (false);
            lab17:
            m_cursor = m_limit - v_12;
            // do, line 130
            v_13 = m_limit - m_cursor;
            do
            {
                // call Step_2, line 130
                if (!r_Step_2())
                {
                    goto lab18;
                }
            } while (false);
            lab18:
            m_cursor = m_limit - v_13;
            // do, line 131
            v_14 = m_limit - m_cursor;
            do
            {
                // call Step_3, line 131
                if (!r_Step_3())
                {
                    goto lab19;
                }
            } while (false);
            lab19:
            m_cursor = m_limit - v_14;
            // do, line 132
            v_15 = m_limit - m_cursor;
            do
            {
                // call Step_4, line 132
                if (!r_Step_4())
                {
                    goto lab20;
                }
            } while (false);
            lab20:
            m_cursor = m_limit - v_15;
            // do, line 133
            v_16 = m_limit - m_cursor;
            do
            {
                // call Step_5a, line 133
                if (!r_Step_5a())
                {
                    goto lab21;
                }
            } while (false);
            lab21:
            m_cursor = m_limit - v_16;
            // do, line 134
            v_17 = m_limit - m_cursor;
            do
            {
                // call Step_5b, line 134
                if (!r_Step_5b())
                {
                    goto lab22;
                }
            } while (false);
            lab22:
            m_cursor = m_limit - v_17;
            m_cursor = m_limit_backward;                    // do, line 137
            v_18 = m_cursor;
            do
            {
                // (, line 137
                // Boolean test Y_found, line 137
                if (!(B_Y_found))
                {
                    goto lab23;
                }
                // repeat, line 137
                while (true)
                {
                    v_19 = m_cursor;
                    do
                    {
                        // (, line 137
                        // goto, line 137
                        while (true)
                        {
                            v_20 = m_cursor;
                            do
                            {
                                // (, line 137
                                // [, line 137
                                m_bra = m_cursor;
                                // literal, line 137
                                if (!(Eq_S(1, "Y")))
                                {
                                    goto lab27;
                                }
                                // ], line 137
                                m_ket = m_cursor;
                                m_cursor = v_20;
                                goto golab26;
                            } while (false);
                            lab27:
                            m_cursor = v_20;
                            if (m_cursor >= m_limit)
                            {
                                goto lab25;
                            }
                            m_cursor++;
                        }
                        golab26:
                        // <-, line 137
                        SliceFrom("y");
                        // LUCENENET NOTE: continue label is not supported directly in .NET,
                        // so we just need to add another goto to get to the end of the outer loop.
                        // See: http://stackoverflow.com/a/359449/181087

                        // Original code:
                        //continue replab24;

                        goto end_of_outer_loop_2;

                    } while (false);
                    lab25:
                    m_cursor = v_19;
                    goto replab24;
                    end_of_outer_loop_2: { }
                }
                replab24:;
            } while (false);
            lab23:
            m_cursor = v_18;
            return true;
        }

        public override bool Equals(object o)
        {
            return o is PorterStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}