/*
 * Decompiled with CFR 0.152.
 */
package org.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.upgrade.DbUpgrade;

public class Driver
implements java.sql.Driver {
    private static final Driver INSTANCE = new Driver();
    private static final String DEFAULT_URL = "jdbc:default:connection";
    private static final ThreadLocal<Connection> DEFAULT_CONNECTION = new ThreadLocal();
    private static volatile boolean registered;

    public Connection connect(String string, Properties properties) throws SQLException {
        try {
            if (properties == null) {
                properties = new Properties();
            }
            if (!this.acceptsURL(string)) {
                return null;
            }
            if (string.equals(DEFAULT_URL)) {
                return DEFAULT_CONNECTION.get();
            }
            Connection connection = DbUpgrade.connectOrUpgrade(string, properties);
            if (connection != null) {
                return connection;
            }
            return new JdbcConnection(string, properties);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    public boolean acceptsURL(String string) {
        if (string != null) {
            if (string.startsWith("jdbc:h2:")) {
                return true;
            }
            if (string.equals(DEFAULT_URL)) {
                return DEFAULT_CONNECTION.get() != null;
            }
        }
        return false;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 3;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static synchronized Driver load() {
        try {
            if (!registered) {
                registered = true;
                DriverManager.registerDriver(INSTANCE);
            }
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
        return INSTANCE;
    }

    public static synchronized void unload() {
        try {
            if (registered) {
                registered = false;
                DriverManager.deregisterDriver(INSTANCE);
            }
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    public static void setDefaultConnection(Connection connection) {
        DEFAULT_CONNECTION.set(connection);
    }

    static {
        Driver.load();
    }
}

