/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.AbstractRemotingProcessor;
import com.alipay.remoting.Connection;
import com.alipay.remoting.InvokeFuture;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.RemotingContext;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.RemotingUtil;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;

public class RpcResponseProcessor
extends AbstractRemotingProcessor<RemotingCommand> {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");

    public RpcResponseProcessor() {
    }

    public RpcResponseProcessor(ExecutorService executor) {
        super(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcess(RemotingContext ctx, RemotingCommand cmd) {
        Connection conn = (Connection)ctx.getChannelContext().channel().attr(Connection.CONNECTION).get();
        InvokeFuture future = conn.removeInvokeFuture(cmd.getId());
        ClassLoader oldClassLoader = null;
        try {
            if (future != null) {
                if (future.getAppClassLoader() != null) {
                    oldClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(future.getAppClassLoader());
                }
                future.putResponse(cmd);
                future.cancelTimeout();
                try {
                    future.executeInvokeCallback();
                }
                catch (Exception e) {
                    logger.error("Exception caught when executing invoke callback, id={}", (Object)cmd.getId(), (Object)e);
                }
            } else {
                logger.warn("Cannot find InvokeFuture, maybe already timeout, id={}, from={} ", (Object)cmd.getId(), (Object)RemotingUtil.parseRemoteAddress(ctx.getChannelContext().channel()));
            }
        }
        finally {
            if (null != oldClassLoader) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }
}

