/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.bizkeeper.event;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import org.apache.servicecomb.bizkeeper.CustomizeCommandGroupKey;
import org.apache.servicecomb.foundation.common.event.AlarmEvent;

public class CircutBreakerEvent
extends AlarmEvent {
    private String role;
    private String microservice;
    private String schema;
    private String operation;
    private long currentTotalRequest;
    private long currentErrorCount;
    private long currentErrorPercentage;
    private int requestVolumeThreshold;
    private int sleepWindowInMilliseconds;
    private int errorThresholdPercentage;

    public CircutBreakerEvent(HystrixCommandKey commandKey, AlarmEvent.Type type) {
        super(type);
        HystrixCommandMetrics hystrixCommandMetrics = HystrixCommandMetrics.getInstance((HystrixCommandKey)commandKey);
        if (hystrixCommandMetrics != null) {
            if (hystrixCommandMetrics.getCommandGroup() instanceof CustomizeCommandGroupKey) {
                CustomizeCommandGroupKey customCommandGroupKey = (CustomizeCommandGroupKey)hystrixCommandMetrics.getCommandGroup();
                this.microservice = customCommandGroupKey.getInstance().getMicroserviceName();
                this.role = customCommandGroupKey.getInstance().getInvocationType().name();
                this.schema = customCommandGroupKey.getInstance().getSchemaId();
                this.operation = customCommandGroupKey.getInstance().getOperationName();
            }
            this.currentTotalRequest = hystrixCommandMetrics.getHealthCounts().getTotalRequests();
            this.currentErrorPercentage = hystrixCommandMetrics.getHealthCounts().getErrorCount();
            this.currentErrorCount = hystrixCommandMetrics.getHealthCounts().getErrorPercentage();
            this.requestVolumeThreshold = (Integer)hystrixCommandMetrics.getProperties().circuitBreakerRequestVolumeThreshold().get();
            this.sleepWindowInMilliseconds = (Integer)hystrixCommandMetrics.getProperties().circuitBreakerSleepWindowInMilliseconds().get();
            this.errorThresholdPercentage = (Integer)hystrixCommandMetrics.getProperties().circuitBreakerErrorThresholdPercentage().get();
        }
    }

    public String getRole() {
        return this.role;
    }

    public String getMicroservice() {
        return this.microservice;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getOperation() {
        return this.operation;
    }

    public long getCurrentTotalRequest() {
        return this.currentTotalRequest;
    }

    public long getCurrentErrorCount() {
        return this.currentErrorCount;
    }

    public long getCurrentErrorPercentage() {
        return this.currentErrorPercentage;
    }

    public int getRequestVolumeThreshold() {
        return this.requestVolumeThreshold;
    }

    public int getSleepWindowInMilliseconds() {
        return this.sleepWindowInMilliseconds;
    }

    public int getErrorThresholdPercentage() {
        return this.errorThresholdPercentage;
    }
}

