/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.processor.injection;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.governance.policy.FaultInjectionPolicy;
import org.apache.servicecomb.governance.processor.injection.AbortFault;
import org.apache.servicecomb.governance.processor.injection.AbstractFault;
import org.apache.servicecomb.governance.processor.injection.DelayFault;
import org.apache.servicecomb.governance.processor.injection.Fault;
import org.apache.servicecomb.governance.processor.injection.FaultParam;

public final class FaultInjectionUtil {
    private static final Map<String, AtomicLong> REQUEST_COUNT = new ConcurrentHashMapEx();

    private FaultInjectionUtil() {
    }

    public static AtomicLong getOperMetTotalReq(String key) {
        return REQUEST_COUNT.computeIfAbsent(key, p -> new AtomicLong(1L));
    }

    public static boolean isFaultNeedToInject(long reqCount, int percentage) {
        long resultNew = reqCount * (long)percentage / 100L;
        long resultOld = (reqCount - 1L) * (long)percentage / 100L;
        return resultNew != resultOld;
    }

    public static Fault getFault(String key, FaultInjectionPolicy policy) {
        AbstractFault fault = null;
        if ("delay".equals(policy.getType())) {
            fault = new DelayFault(key, policy);
        } else if ("abort".equals(policy.getType())) {
            fault = new AbortFault(key, policy);
        }
        return fault;
    }

    public static FaultParam initFaultParam(String key) {
        AtomicLong reqCount = FaultInjectionUtil.getOperMetTotalReq(key);
        long reqCountCurrent = reqCount.getAndIncrement();
        FaultParam param = new FaultParam(reqCountCurrent);
        Context currentContext = Vertx.currentContext();
        if (currentContext != null && currentContext.owner() != null && currentContext.isEventLoopContext()) {
            param.setSleepable(delay -> currentContext.owner().setTimer(delay, timeId -> {}));
        }
        return param;
    }
}

