/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.config.archaius.sources.ApolloConfigurationSourceImpl;
import org.apache.servicecomb.config.client.ApolloConfig;
import org.apache.servicecomb.config.client.ConfigurationAction;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ApolloClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApolloClient.class);
    private static final ApolloConfig APOLLO_CONFIG = ApolloConfig.INSTANCE;
    private static final Map<String, Object> originalConfigMap = new ConcurrentHashMap<String, Object>();
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(1);
    private final int refreshInterval = APOLLO_CONFIG.getRefreshInterval();
    private final int firstRefreshInterval = APOLLO_CONFIG.getFirstRefreshInterval();
    private final String serviceUri = APOLLO_CONFIG.getServerUri();
    private final String serviceName = APOLLO_CONFIG.getServiceName();
    private final String token = APOLLO_CONFIG.getToken();
    private final String env = APOLLO_CONFIG.getEnv();
    private final String clusters = APOLLO_CONFIG.getServerClusters();
    private final String namespace = APOLLO_CONFIG.getNamespace();
    private final ApolloConfigurationSourceImpl.UpdateHandler updateHandler;
    private static RestTemplate rest = new RestTemplate();

    public ApolloClient(ApolloConfigurationSourceImpl.UpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    @VisibleForTesting
    static Map<String, Object> getOriginalConfigMap() {
        return originalConfigMap;
    }

    @VisibleForTesting
    static void setRest(RestTemplate rest) {
        ApolloClient.rest = rest;
    }

    public void refreshApolloConfig() {
        EXECUTOR.scheduleWithFixedDelay(new ConfigRefresh(this.serviceUri), this.firstRefreshInterval, this.refreshInterval, TimeUnit.SECONDS);
    }

    class ConfigRefresh
    implements Runnable {
        private final String serviceUri;

        ConfigRefresh(String serviceUris) {
            this.serviceUri = serviceUris;
        }

        @Override
        public void run() {
            try {
                this.refreshConfig();
            }
            catch (Throwable e) {
                LOGGER.error("client refresh thread exception ", e);
            }
        }

        void refreshConfig() {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/json;charset=UTF-8");
            headers.add("Authorization", ApolloClient.this.token);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity exchange = rest.exchange(this.composeAPI(), HttpMethod.GET, entity, String.class, new Object[0]);
            if (HttpResponseStatus.OK.code() == exchange.getStatusCode().value()) {
                try {
                    Map body = (Map)JsonUtils.OBJ_MAPPER.readValue((String)exchange.getBody(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    this.refreshConfigItems((Map)body.get("configurations"));
                }
                catch (IOException e) {
                    LOGGER.error("JsonObject parse config center response error: ", (Throwable)e);
                }
            } else {
                LOGGER.error("fetch configuration failed, error code:{} for {}", (Object)exchange.getStatusCodeValue(), exchange.getBody());
            }
        }

        private String composeAPI() {
            String api = this.serviceUri + "/openapi/v1/envs/" + ApolloClient.this.env + "/apps/" + ApolloClient.this.serviceName + "/clusters/" + ApolloClient.this.clusters + "/namespaces/" + ApolloClient.this.namespace + "/releases/latest";
            return api;
        }

        private void refreshConfigItems(Map<String, Object> map) {
            this.compareChangedConfig(originalConfigMap, map);
            originalConfigMap.clear();
            originalConfigMap.putAll(map);
        }

        void compareChangedConfig(Map<String, Object> before, Map<String, Object> after) {
            HashMap<String, Object> itemsCreated = new HashMap<String, Object>();
            HashMap<String, Object> itemsDeleted = new HashMap<String, Object>();
            HashMap<String, Object> itemsModified = new HashMap<String, Object>();
            if (before == null || before.isEmpty()) {
                ApolloClient.this.updateHandler.handle(ConfigurationAction.CREATE, after);
                return;
            }
            if (after == null || after.isEmpty()) {
                ApolloClient.this.updateHandler.handle(ConfigurationAction.DELETE, before);
                return;
            }
            after.forEach((itemKey, itemValue) -> {
                if (!before.containsKey(itemKey)) {
                    itemsCreated.put((String)itemKey, itemValue);
                } else if (!itemValue.equals(before.get(itemKey))) {
                    itemsModified.put((String)itemKey, itemValue);
                }
            });
            for (String itemKey2 : before.keySet()) {
                if (after.containsKey(itemKey2)) continue;
                itemsDeleted.put(itemKey2, "");
            }
            ApolloClient.this.updateHandler.handle(ConfigurationAction.CREATE, itemsCreated);
            ApolloClient.this.updateHandler.handle(ConfigurationAction.SET, itemsModified);
            ApolloClient.this.updateHandler.handle(ConfigurationAction.DELETE, itemsDeleted);
        }
    }
}

