/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.enums;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Type;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.util.Collection;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.EnumMeta;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedWriteSchemas;

public class EnumPackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedWriteSchemas.create(protoField, propertyDescriptor, new EnumsPackedWriters(protoField, propertyDescriptor.getJavaType()));
    }

    private static class EnumsPackedWriters
    extends AbstractWriters<Enum<?>> {
        private final EnumMeta enumMeta;

        public EnumsPackedWriters(Field protoField, JavaType javaType) {
            super(protoField, (Class)ReflectUtils.constructArrayType(Enum.class));
            this.enumMeta = new EnumMeta(protoField, javaType);
            this.arrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (Enum element : array) {
                    if (element == null) {
                        ProtoUtils.throwNotSupportNullElement(protoField);
                        return;
                    }
                    String name = element.name();
                    Integer enumValue = this.enumMeta.getValueByName(name);
                    if (enumValue == null) {
                        throw new IllegalStateException(String.format("invalid enum name %s for proto %s, field=%s:%s", name, protoField.getTypeName(), ((Type)protoField.getParent()).getCanonicalName(), protoField.getName()));
                    }
                    output.writePackedEnum(enumValue);
                }
            });
            this.collectionWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, collection) -> {
                Object first = collection.iterator().next();
                if (first.getClass().isEnum()) {
                    this.writeEnumCollection(output, (Collection<Enum<?>>)collection);
                    return;
                }
                if (first.getClass() == String.class) {
                    this.writeStringCollection(output, (Collection<String>)collection);
                    return;
                }
                this.writeIntCollection(output, (Collection<Number>)collection);
            });
            this.stringArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (String element : array) {
                    if (element == null) {
                        ProtoUtils.throwNotSupportNullElement(protoField);
                        return;
                    }
                    Integer enumValue = this.enumMeta.getValueByName(element);
                    if (enumValue == null) {
                        throw new IllegalStateException(String.format("invalid enum name %s for proto %s, field=%s:%s", element, protoField.getTypeName(), ((Type)protoField.getParent()).getCanonicalName(), protoField.getName()));
                    }
                    output.writePackedEnum(enumValue);
                }
            });
        }

        private void writeStringCollection(OutputEx output, Collection<String> collection) throws IOException {
            for (String element : collection) {
                if (element == null) {
                    ProtoUtils.throwNotSupportNullElement(this.protoField);
                    return;
                }
                Integer enumValue = this.enumMeta.getValueByName(element);
                if (enumValue == null) {
                    throw new IllegalStateException(String.format("invalid enum name %s for proto %s, field=%s:%s", element, this.protoField.getTypeName(), ((Type)this.protoField.getParent()).getCanonicalName(), this.protoField.getName()));
                }
                output.writePackedEnum(enumValue);
            }
        }

        private void writeIntCollection(OutputEx output, Collection<Number> collection) throws IOException {
            for (Number element : collection) {
                if (element == null) {
                    ProtoUtils.throwNotSupportNullElement(this.protoField);
                    return;
                }
                output.writePackedInt32(element.intValue());
            }
        }

        private void writeEnumCollection(OutputEx output, Collection<Enum<?>> collection) throws IOException {
            for (Enum<?> element : collection) {
                if (element == null) {
                    ProtoUtils.throwNotSupportNullElement(this.protoField);
                    return;
                }
                String name = element.name();
                Integer enumValue = this.enumMeta.getValueByName(name);
                if (enumValue == null) {
                    throw new IllegalStateException(String.format("invalid enum name %s for proto %s, field=%s:%s", name, this.protoField.getTypeName(), ((Type)this.protoField.getParent()).getCanonicalName(), this.protoField.getName()));
                }
                output.writePackedEnum(enumValue);
            }
        }
    }
}

