/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.driver.jdbc.unsupported;

import org.apache.shardingsphere.driver.jdbc.adapter.WrapperAdapter;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

/**
 * Unsupported {@code ParameterMetaData} methods.
 */
public abstract class AbstractUnsupportedOperationParameterMetaData extends WrapperAdapter implements ParameterMetaData {
    
    @Override
    public final int isNullable(final int parameter) throws SQLException {
        throw new SQLFeatureNotSupportedException("isNullable");
    }
    
    @Override
    public final boolean isSigned(final int parameter) throws SQLException {
        throw new SQLFeatureNotSupportedException("isSigned");
    }
    
    @Override
    public final int getPrecision(final int parameter) throws SQLException {
        throw new SQLFeatureNotSupportedException("getPrecision");
    }
    
    @Override
    public final int getScale(final int parameter) throws SQLException {
        throw new SQLFeatureNotSupportedException("getScale");
    }
    
    @Override
    public final int getParameterType(final int parameter) throws SQLException {
        throw new SQLFeatureNotSupportedException("getParameterType");
    }
    
    @Override
    public final String getParameterTypeName(final int parameter) throws SQLException {
        throw new SQLFeatureNotSupportedException("getParameterTypeName");
    }
    
    @Override
    public final String getParameterClassName(final int parameter) throws SQLException {
        throw new SQLFeatureNotSupportedException("getParameterClassName");
    }
    
    @Override
    public final int getParameterMode(final int parameter) throws SQLException {
        throw new SQLFeatureNotSupportedException("getParameterMode");
    }
}
