/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.UnmarshallerHandler;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.attachment.AttachmentUnmarshaller;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.Pooled;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformingReader;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.internal.shared.ExternalLinkHandler;
import org.apache.sis.xml.internal.shared.InputFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

final class PooledUnmarshaller
extends Pooled
implements Unmarshaller {
    private final Unmarshaller unmarshaller;

    PooledUnmarshaller(Unmarshaller unmarshaller, Pooled template) throws JAXBException {
        super(template);
        this.unmarshaller = unmarshaller;
        this.initialize(template);
    }

    @Override
    protected void reset(Object key, Object value) throws JAXBException {
        if (key instanceof String) {
            this.unmarshaller.setProperty((String)key, value);
        } else if (key == AttachmentUnmarshaller.class) {
            this.unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)value);
        } else if (key == Schema.class) {
            this.unmarshaller.setSchema((Schema)value);
        } else if (key == Unmarshaller.Listener.class) {
            this.unmarshaller.setListener((Unmarshaller.Listener)value);
        } else if (key == ValidationEventHandler.class) {
            this.unmarshaller.setEventHandler((ValidationEventHandler)value);
        } else {
            this.unmarshaller.setAdapter((Class)key, (XmlAdapter)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unmarshal(XMLEventReader input, TransformVersion version, ExternalLinkHandler linkHandler) throws XMLStreamException, JAXBException {
        Object object;
        input = new TransformingReader(input, version);
        Context context = this.begin(linkHandler);
        try {
            object = PooledUnmarshaller.resolve(this.unmarshaller.unmarshal(input), linkHandler, context);
        }
        finally {
            context.finish();
        }
        input.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> JAXBElement<T> unmarshal(XMLEventReader input, TransformVersion version, ExternalLinkHandler linkHandler, Class<T> declaredType) throws XMLStreamException, JAXBException {
        JAXBElement object;
        input = new TransformingReader(input, version);
        Context context = this.begin(linkHandler);
        try {
            object = this.unmarshaller.unmarshal(input, declaredType);
        }
        finally {
            context.finish();
        }
        input.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(InputStream input) throws JAXBException {
        ExternalLinkHandler linkHandler = ExternalLinkHandler.forStream(input);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                return this.unmarshal(InputFactory.createXMLEventReader(input), version, linkHandler);
            }
            catch (XMLStreamException e) {
                throw PooledUnmarshaller.cannotParse(null, e);
            }
        }
        Context context = this.begin(linkHandler);
        try {
            Object object = PooledUnmarshaller.resolve(this.unmarshaller.unmarshal(input), linkHandler, context);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object unmarshal(URL input) throws JAXBException {
        TransformVersion version = this.getTransformVersion();
        HashSet<URL> done = new HashSet<URL>();
        try {
            HttpURLConnection hc;
            URLConnection connection;
            block14: while ((connection = input.openConnection()) instanceof HttpURLConnection && (hc = (HttpURLConnection)connection).getInstanceFollowRedirects()) {
                switch (hc.getResponseCode()) {
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: 
                    case 308: {
                        if (!done.add(input)) {
                            throw new IOException(Errors.format((short)10, (Object)input));
                        }
                        String location = hc.getHeaderField("Location");
                        if (location == null) break block14;
                        input = input.toURI().resolve(new URI(location)).toURL();
                        continue block14;
                    }
                }
            }
            ExternalLinkHandler linkHandler = new ExternalLinkHandler(input);
            try (InputStream s = connection.getInputStream();){
                if (version != null) {
                    Object object = this.unmarshal(InputFactory.createXMLEventReader(s), version, linkHandler);
                    return object;
                }
                Context context = this.begin(linkHandler);
                try {
                    Object object = PooledUnmarshaller.resolve(this.unmarshaller.unmarshal(s), linkHandler, context);
                    context.finish();
                    return object;
                }
                catch (Throwable throwable) {
                    context.finish();
                    throw throwable;
                }
            }
        }
        catch (IOException | URISyntaxException | XMLStreamException e) {
            throw PooledUnmarshaller.cannotParse(input, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(File input) throws JAXBException {
        ExternalLinkHandler linkHandler = new ExternalLinkHandler(input);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            Object object;
            BufferedInputStream s = new BufferedInputStream(new FileInputStream(input));
            try {
                object = this.unmarshal(InputFactory.createXMLEventReader(s), version, linkHandler);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)s).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | XMLStreamException e) {
                    throw PooledUnmarshaller.cannotParse(input, e);
                }
            }
            ((InputStream)s).close();
            return object;
        }
        Context context = this.begin(linkHandler);
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Reader input) throws JAXBException {
        ExternalLinkHandler linkHandler = ExternalLinkHandler.forStream(input);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                return this.unmarshal(InputFactory.createXMLEventReader(input), version, linkHandler);
            }
            catch (XMLStreamException e) {
                throw PooledUnmarshaller.cannotParse(null, e);
            }
        }
        Context context = this.begin(linkHandler);
        try {
            Object object = PooledUnmarshaller.resolve(this.unmarshaller.unmarshal(input), linkHandler, context);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(InputSource input) throws JAXBException {
        ExternalLinkHandler linkHandler = new ExternalLinkHandler(input.getSystemId());
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                return this.unmarshal(InputFactory.createXMLEventReader(input), version, linkHandler);
            }
            catch (XMLStreamException e) {
                throw PooledUnmarshaller.cannotParse(input.getPublicId(), e);
            }
        }
        Context context = this.begin(linkHandler);
        try {
            Object object = PooledUnmarshaller.resolve(this.unmarshaller.unmarshal(input), linkHandler, context);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Node input) throws JAXBException {
        ExternalLinkHandler linkHandler = new ExternalLinkHandler(input.getBaseURI());
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                return this.unmarshal(InputFactory.createXMLEventReader(input), version, linkHandler);
            }
            catch (XMLStreamException e) {
                throw PooledUnmarshaller.cannotParse(input.getNodeName(), e);
            }
        }
        Context context = this.begin(linkHandler);
        try {
            Object object = PooledUnmarshaller.resolve(this.unmarshaller.unmarshal(input), linkHandler, context);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JAXBElement<T> unmarshal(Node input, Class<T> declaredType) throws JAXBException {
        ExternalLinkHandler linkHandler = new ExternalLinkHandler(input.getBaseURI());
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                return this.unmarshal(InputFactory.createXMLEventReader(input), version, linkHandler, declaredType);
            }
            catch (XMLStreamException e) {
                throw PooledUnmarshaller.cannotParse(input.getNodeName(), e);
            }
        }
        Context context = this.begin(linkHandler);
        try {
            JAXBElement jAXBElement = this.unmarshaller.unmarshal(input, declaredType);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Source input) throws JAXBException {
        ExternalLinkHandler linkHandler = new ExternalLinkHandler(input);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                return this.unmarshal(InputFactory.createXMLEventReader(input), version, linkHandler);
            }
            catch (XMLStreamException e) {
                throw PooledUnmarshaller.cannotParse(input.getSystemId(), e);
            }
        }
        Context context = this.begin(linkHandler);
        try {
            Object object = PooledUnmarshaller.resolve(this.unmarshaller.unmarshal(input), linkHandler, context);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JAXBElement<T> unmarshal(Source input, Class<T> declaredType) throws JAXBException {
        ExternalLinkHandler linkHandler = new ExternalLinkHandler(input);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                return this.unmarshal(InputFactory.createXMLEventReader(input), version, linkHandler, declaredType);
            }
            catch (XMLStreamException e) {
                throw PooledUnmarshaller.cannotParse(input.getSystemId(), e);
            }
        }
        Context context = this.begin(linkHandler);
        try {
            JAXBElement jAXBElement = this.unmarshaller.unmarshal(input, declaredType);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(XMLStreamReader input) throws JAXBException {
        ExternalLinkHandler linkHandler = ExternalLinkHandler.create(input);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                return this.unmarshal(InputFactory.createXMLEventReader(input), version, linkHandler);
            }
            catch (XMLStreamException e) {
                throw PooledUnmarshaller.cannotParse(input.getLocalName(), e);
            }
        }
        Context context = this.begin(linkHandler);
        try {
            Object object = PooledUnmarshaller.resolve(this.unmarshaller.unmarshal(input), linkHandler, context);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JAXBElement<T> unmarshal(XMLStreamReader input, Class<T> declaredType) throws JAXBException {
        ExternalLinkHandler linkHandler = ExternalLinkHandler.create(input);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                return this.unmarshal(InputFactory.createXMLEventReader(input), version, linkHandler, declaredType);
            }
            catch (XMLStreamException e) {
                throw PooledUnmarshaller.cannotParse(input.getLocalName(), e);
            }
        }
        Context context = this.begin(linkHandler);
        try {
            JAXBElement jAXBElement = this.unmarshaller.unmarshal(input, declaredType);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(XMLEventReader input) throws JAXBException {
        ExternalLinkHandler linkHandler;
        try {
            linkHandler = ExternalLinkHandler.create(input);
        }
        catch (XMLStreamException e) {
            throw PooledUnmarshaller.cannotParse(null, e);
        }
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            input = new TransformingReader(input, version);
        }
        Context context = this.begin(linkHandler);
        try {
            Object object = PooledUnmarshaller.resolve(this.unmarshaller.unmarshal(input), linkHandler, context);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JAXBElement<T> unmarshal(XMLEventReader input, Class<T> declaredType) throws JAXBException {
        ExternalLinkHandler linkHandler;
        try {
            linkHandler = ExternalLinkHandler.create(input);
        }
        catch (XMLStreamException e) {
            throw PooledUnmarshaller.cannotParse(null, e);
        }
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            input = new TransformingReader(input, version);
        }
        Context context = this.begin(linkHandler);
        try {
            JAXBElement jAXBElement = this.unmarshaller.unmarshal(input, declaredType);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    private static Object resolve(Object object, ExternalLinkHandler linkHandler, Context context) {
        String fragment;
        if (linkHandler != null && (fragment = linkHandler.getFragment()) != null) {
            Object r = Context.getObjectForID(context, fragment);
            if (r != null) {
                return r;
            }
            Context.warningOccured(context, PooledUnmarshaller.class, "unmarshal", Errors.class, (short)134, fragment);
        }
        return object;
    }

    private static JAXBException cannotParse(Object input, Exception cause) {
        return new JAXBException(input != null ? Errors.format((short)15, (Object)input) : cause.getMessage(), (Throwable)cause);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.unmarshaller.getUnmarshallerHandler();
    }

    @Override
    void setStandardProperty(String name, Object value) throws PropertyException {
        this.unmarshaller.setProperty(name, value);
    }

    @Override
    Object getStandardProperty(String name) throws PropertyException {
        return this.unmarshaller.getProperty(name);
    }

    @Override
    public <A extends XmlAdapter<?, ?>> void setAdapter(Class<A> type, A adapter) {
        super.setAdapter(type, adapter);
        this.unmarshaller.setAdapter(type, adapter);
    }

    @Override
    public <A extends XmlAdapter<?, ?>> A getAdapter(Class<A> type) {
        return (A)this.unmarshaller.getAdapter(type);
    }

    @Override
    public void setSchema(Schema schema) {
        super.setSchema(schema);
        this.unmarshaller.setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.unmarshaller.getSchema();
    }

    @Override
    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        super.setEventHandler(handler);
        this.unmarshaller.setEventHandler(handler);
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.unmarshaller.getEventHandler();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller au) {
        if (!this.isPropertySaved(AttachmentUnmarshaller.class)) {
            this.saveProperty(AttachmentUnmarshaller.class, this.unmarshaller.getAttachmentUnmarshaller());
        }
        this.unmarshaller.setAttachmentUnmarshaller(au);
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.unmarshaller.getAttachmentUnmarshaller();
    }

    public void setListener(Unmarshaller.Listener listener) {
        if (!this.isPropertySaved(Unmarshaller.Listener.class)) {
            this.saveProperty(Unmarshaller.Listener.class, this.unmarshaller.getListener());
        }
        this.unmarshaller.setListener(listener);
    }

    public Unmarshaller.Listener getListener() {
        return this.unmarshaller.getListener();
    }
}

