/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.internal;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.metrics.MetricsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Config.class, factory=true)
public class JmxExporterFactory {
    String[] patterns;
    private static final Logger LOG = LoggerFactory.getLogger(JmxExporterFactory.class);
    @Reference
    MetricsService metrics;
    MBeanServer server;
    NotificationListener listener = new NotificationListener(){

        @Override
        public void handleNotification(Notification notification, Object handback) {
            block5: {
                if ("JMX.mbean.registered".equals(notification.getType())) {
                    ObjectName objectname = null;
                    try {
                        if (notification instanceof MBeanServerNotification) {
                            MBeanServerNotification mbeanNotification = (MBeanServerNotification)notification;
                            objectname = mbeanNotification.getMBeanName();
                            LOG.debug("JMX Notification : match {} with pattern = {}", (Object)objectname, Arrays.asList(JmxExporterFactory.this.patterns));
                            for (String pattern : JmxExporterFactory.this.patterns) {
                                if (!objectname.toString().matches(pattern)) continue;
                                LOG.debug("JMX Notification : register metrics for MBean: {}", (Object)objectname);
                                JmxExporterFactory.this.registerMBeanProperties(objectname);
                                break block5;
                            }
                            break block5;
                        }
                        LOG.debug("JMX Notification : Cannot handle notification, because it's not a MBeanServerNotification ({})", (Object)notification);
                    }
                    catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
                        LOG.error("JMX Notification : Cannot register metrics for objectname = {}", objectname, (Object)e);
                    }
                }
            }
        }
    };

    @Activate
    @Modified
    public void activate(Config config) {
        this.server = ManagementFactory.getPlatformMBeanServer();
        this.patterns = config.objectnames();
        try {
            this.server.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener, null, null);
        }
        catch (InstanceNotFoundException e) {
            LOG.error("Cannot add notification listener to MBeanServerDelegate", (Throwable)e);
        }
        this.registerMetrics(this.patterns);
    }

    private void registerMetrics(String[] patterns) {
        for (String patternString : patterns) {
            try {
                ObjectName pattern = new ObjectName(patternString);
                Set<ObjectName> allMBeans = this.server.queryNames(pattern, null);
                if (allMBeans.isEmpty()) {
                    LOG.info("pattern {} does not match any MBean", (Object)patternString);
                    continue;
                }
                allMBeans.forEach(objectname -> {
                    LOG.debug("registering properties for {}", objectname);
                    try {
                        this.registerMBeanProperties((ObjectName)objectname);
                    }
                    catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
                        LOG.error("Cannot register metrics for objectname = {}", objectname, (Object)e);
                    }
                });
            }
            catch (MalformedObjectNameException e) {
                LOG.error("cannot create an objectname from pattern {}", (Object)patternString, (Object)e);
            }
        }
    }

    protected void registerMBeanProperties(ObjectName objectname) throws InstanceNotFoundException, ReflectionException, IntrospectionException {
        MBeanAttributeInfo[] attributes;
        MBeanInfo info = this.server.getMBeanInfo(objectname);
        for (MBeanAttributeInfo attr : attributes = info.getAttributes()) {
            LOG.debug("Checking mbean = {}, name = {}, type={}", new Object[]{objectname, attr.getName(), attr.getType()});
            Supplier<Object> supplier = null;
            if ("int".equals(attr.getType())) {
                supplier = this.getSupplier(objectname, attr.getName(), 0);
            } else if ("long".equals(attr.getType())) {
                supplier = this.getSupplier(objectname, attr.getName(), 0L);
            } else if ("java.lang.String".equals(attr.getType())) {
                supplier = this.getSupplier(objectname, attr.getName(), "");
            } else if ("double".equals(attr.getType())) {
                supplier = this.getSupplier(objectname, attr.getName(), 0.0);
            } else if ("boolean".equals(attr.getType())) {
                supplier = this.getSupplier(objectname, attr.getName(), Boolean.FALSE);
            }
            if (supplier == null) continue;
            String metricName = this.toMetricName(objectname, attr.getName());
            LOG.info("Registering metric {} from MBean (objectname=[{}], name={}, type={})", new Object[]{metricName, objectname, attr.getName(), attr.getType()});
            this.metrics.gauge(metricName, supplier);
        }
    }

    private <T> Supplier<T> getSupplier(ObjectName name, String attributeName, T defaultValue) {
        return () -> {
            try {
                return this.server.getAttribute(name, attributeName);
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                LOG.warn("error when retrieving value for MBean (objectname=[{}], attribute={})", new Object[]{name, attributeName, e});
                return defaultValue;
            }
        };
    }

    protected String toMetricName(ObjectName objectName, String attributeName) {
        String name = "sling";
        if (!StringUtils.isBlank((CharSequence)objectName.getDomain())) {
            name = objectName.getDomain();
        }
        Hashtable<String, String> allkeys = objectName.getKeyPropertyList();
        ArrayList<String> keyValues = new ArrayList<String>(allkeys.values());
        Collections.sort(keyValues);
        StringBuilder builder = new StringBuilder(name);
        for (String s : keyValues) {
            builder.append("." + s);
        }
        builder.append("." + attributeName);
        return builder.toString();
    }

    @ObjectClassDefinition(name="JMX to Metrics Exporter")
    public static @interface Config {
        @AttributeDefinition(name="objectnames", description="export all attribute of the MBeans matching these objectnames as Sling Metrics(see https://docs.oracle.com/en/java/javase/11/docs/api/java.management/javax/management/ObjectName.html")
        public String[] objectnames();

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Pattern: {objectnames}";
    }
}

