/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.config;

import javax.jcr.Credentials;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.SimpleCredentialsConfig;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class CredentialsConfig {
    public final String type;
    public static final String ATTR_TYPE = "type";
    public static final String ELEM_CREDETIALS = "credentials";

    public CredentialsConfig(String type) {
        this.type = type;
    }

    public static CredentialsConfig load(Element elem) throws ConfigurationException {
        assert (elem.getNodeName().equals(ELEM_CREDETIALS));
        String type = elem.getAttribute(ATTR_TYPE);
        if (type == null || type.equals("simple")) {
            return SimpleCredentialsConfig.load(elem);
        }
        throw new ConfigurationException("unknown credentials type: " + type);
    }

    public abstract Credentials getCredentials();

    @Deprecated
    public void write(ContentHandler handler) throws SAXException {
        throw new UnsupportedOperationException("No longer supports write with a SAX contentHandler, user write with XMLStreamWriter instead!");
    }

    protected abstract void writeInner(ContentHandler var1) throws SAXException;

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(ELEM_CREDETIALS);
        writer.writeAttribute(ATTR_TYPE, this.type);
        this.writeInner(writer);
        writer.writeEndElement();
    }

    protected abstract void writeInner(XMLStreamWriter var1) throws XMLStreamException;
}

