/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.DocViewParser;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.apache.sling.feature.cpconverter.index.IndexDefinitions;
import org.apache.sling.feature.cpconverter.index.IndexManager;
import org.apache.sling.feature.cpconverter.index.SimpleNamespaceResolver;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;

public class IndexDefinitionsEntryHandler
extends AbstractRegexEntryHandler {
    private static final String[] EXCLUDED_EXTENSIONS = new String[]{"vlt", "gitignore"};
    private static final String PATH_PATTERN = "/jcr_root(.*/?)/" + PlatformNameFormat.getPlatformName((String)"oak:index") + "(.*/?)/(.*?)\\.(?!(" + String.join((CharSequence)"|", EXCLUDED_EXTENSIONS) + ")$)[^.]+$";
    private static final String EXTENSION_XML = ".xml";
    private static final String NODETYPE_OAK_QUERY_INDEX_DEFINITION = "oak:QueryIndexDefinition";

    private static final String removeXmlExtension(String input) {
        if (!input.endsWith(EXTENSION_XML)) {
            throw new IllegalArgumentException(String.format("Input string '%s' does not end in '%s'", input, EXTENSION_XML));
        }
        return input.substring(0, input.length() - EXTENSION_XML.length());
    }

    private static boolean isOakIndexDefinitionAsFullCoverageAggregate(@NotNull String repositoryPath, @NotNull Archive archive, @NotNull Archive.Entry entry) throws IOException, DocViewParser.XmlParseException {
        if (!repositoryPath.endsWith(EXTENSION_XML)) {
            return false;
        }
        DocViewParser parser = new DocViewParser((NamespaceResolver)new SimpleNamespaceResolver());
        try (InputStream isCheck = archive.openInputStream(entry);){
            IndexDefinitionAsFullCoverageDetectorParserHandler parserHandler = new IndexDefinitionAsFullCoverageDetectorParserHandler(repositoryPath);
            parser.parse(repositoryPath, new InputSource(isCheck), (DocViewParserHandler)parserHandler);
            boolean bl = parserHandler.isIsIndexDefinitionAsFullCoverage();
            return bl;
        }
    }

    public IndexDefinitionsEntryHandler() {
        super(PATH_PATTERN);
    }

    @Override
    public void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter, String runMode) throws IOException, ConverterException {
        IndexManager indexManager = converter.getIndexManager();
        if (indexManager == null) {
            this.logger.info("{} not present, will skip index definition extraction", (Object)IndexManager.class.getName());
        } else {
            try (InputStream is = archive.openInputStream(entry);){
                String platformPath = path.replaceAll("^/jcr_root", "").replaceAll("/\\.content\\.xml$", "").replace(".dir", "");
                String repositoryPath = PlatformNameFormat.getRepositoryPath((String)platformPath);
                InputSource inputSource = new InputSource(is);
                boolean isDocView = false;
                try (InputStream isCheck = archive.openInputStream(entry);){
                    isDocView = DocViewParser.isDocView((InputSource)new InputSource(isCheck));
                }
                if (isDocView) {
                    DocViewParser parser = new DocViewParser((NamespaceResolver)new SimpleNamespaceResolver());
                    if (IndexDefinitionsEntryHandler.isOakIndexDefinitionAsFullCoverageAggregate(repositoryPath, archive, entry)) {
                        repositoryPath = IndexDefinitionsEntryHandler.removeXmlExtension(repositoryPath);
                    }
                    IndexDefinitionsParserHandler handler = new IndexDefinitionsParserHandler(archive.getMetaInf().getFilter(), indexManager.getIndexes());
                    parser.parse(repositoryPath, inputSource, (DocViewParserHandler)handler);
                } else if (archive.getMetaInf().getFilter().contains(repositoryPath)) {
                    indexManager.getIndexes().registerBinary(repositoryPath, is);
                }
            }
            catch (DocViewParser.XmlParseException e) {
                throw new ConverterException("Failed parsing the index definitions", e);
            }
        }
        converter.getMainPackageAssembler().addEntry(path, archive, entry);
    }

    static final class IndexDefinitionAsFullCoverageDetectorParserHandler
    extends DocViewParserHandlerAdapter {
        @NotNull
        private final String repositoryPath;
        private boolean isIndexDefinitionAsFullCoverage;

        private IndexDefinitionAsFullCoverageDetectorParserHandler(@NotNull String repositoryPath) {
            this.repositoryPath = repositoryPath;
        }

        @Override
        public void startDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
            boolean isTopLevelDocViewNode = nodePath.equals(this.repositoryPath);
            boolean isOakQueryIndexDefinition = docViewNode.getPrimaryType().orElse("").equals(IndexDefinitionsEntryHandler.NODETYPE_OAK_QUERY_INDEX_DEFINITION);
            if (isTopLevelDocViewNode && isOakQueryIndexDefinition) {
                this.isIndexDefinitionAsFullCoverage = true;
            }
        }

        public boolean isIsIndexDefinitionAsFullCoverage() {
            return this.isIndexDefinitionAsFullCoverage;
        }
    }

    static class IndexDefinitionsParserHandler
    extends DocViewParserHandlerAdapter {
        private final WorkspaceFilter filter;
        private IndexDefinitions definitions;

        public IndexDefinitionsParserHandler(WorkspaceFilter filter, IndexDefinitions definitions) {
            this.filter = filter;
            this.definitions = definitions;
        }

        @Override
        public void startDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
            if (nodePath.contains("/oak:index") && this.filter.contains(nodePath)) {
                this.definitions.addNode(Text.getRelativeParent((String)nodePath, (int)1), docViewNode);
            }
        }

        public void startPrefixMapping(String prefix, String uri) {
            this.definitions.registerPrefixMapping(prefix, uri);
        }
    }

    static class DocViewParserHandlerAdapter
    implements DocViewParserHandler {
        DocViewParserHandlerAdapter() {
        }

        public void startDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
        }

        public void endDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
        }
    }
}

