/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi2dav;

import java.lang.reflect.Constructor;
import org.w3c.dom.Element;
import relocated_for_contentpackage.javax.jcr.InvalidItemStateException;
import relocated_for_contentpackage.javax.jcr.ItemNotFoundException;
import relocated_for_contentpackage.javax.jcr.PathNotFoundException;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.UnsupportedRepositoryOperationException;
import relocated_for_contentpackage.javax.jcr.lock.LockException;
import relocated_for_contentpackage.javax.jcr.nodetype.ConstraintViolationException;
import relocated_for_contentpackage.org.apache.http.client.methods.HttpRequestBase;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.DavConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.DavException;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.DavMethods;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.xml.DomUtil;

public class ExceptionConverter {
    private ExceptionConverter() {
    }

    public static RepositoryException generate(DavException davExc) {
        return ExceptionConverter.generate(davExc, null);
    }

    public static RepositoryException generate(DavException davExc, HttpRequestBase request) {
        String name = request == null ? "_undefined_" : request.getMethod();
        int code = DavMethods.getMethodCode(name);
        return ExceptionConverter.generate(davExc, code, name);
    }

    public static RepositoryException generate(DavException davExc, int methodCode, String name) {
        String msg = davExc.getMessage();
        if (davExc.hasErrorCondition()) {
            try {
                Element error = davExc.toXml(DomUtil.createDocument());
                if (DomUtil.matches(error, "error", DavConstants.NAMESPACE) && DomUtil.hasChildElement(error, "exception", null)) {
                    Class<?> cl;
                    Constructor<?> excConstr;
                    Element exc = DomUtil.getChildElement(error, "exception", null);
                    if (DomUtil.hasChildElement(exc, "message", null)) {
                        msg = DomUtil.getChildText(exc, "message", null);
                    }
                    if (DomUtil.hasChildElement(exc, "class", null) && (excConstr = (cl = Class.forName(DomUtil.getChildText(exc, "class", null))).getConstructor(String.class)) != null) {
                        Object o = excConstr.newInstance(msg);
                        if (o instanceof PathNotFoundException && methodCode == 4) {
                            return new InvalidItemStateException(msg);
                        }
                        if (o instanceof RepositoryException) {
                            return (RepositoryException)o;
                        }
                        if (o instanceof Exception) {
                            return new RepositoryException(msg, (Exception)o);
                        }
                    }
                }
            }
            catch (Exception e) {
                return new RepositoryException(e);
            }
        }
        switch (davExc.getErrorCode()) {
            case 404: {
                switch (methodCode) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: {
                        return new InvalidItemStateException(msg, davExc);
                    }
                }
                return new ItemNotFoundException(msg, davExc);
            }
            case 423: {
                return new LockException(msg, davExc);
            }
            case 405: {
                return new ConstraintViolationException(msg, davExc);
            }
            case 409: {
                return new InvalidItemStateException(msg, davExc);
            }
            case 412: {
                return new LockException(msg, davExc);
            }
            case 501: {
                if (methodCode > 0 && name != null) {
                    return new UnsupportedRepositoryOperationException("Missing implementation: Method " + name + " could not be executed", davExc);
                }
                return new UnsupportedRepositoryOperationException("Missing implementation", davExc);
            }
        }
        return new RepositoryException(msg, davExc);
    }
}

