/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet.junit5;

import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.junit.platform.engine.TestEngine;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEngineTracker
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TestEngineTracker.class);
    private final BundleTracker<AtomicReference<Set<TestEngine>>> tracker;

    public TestEngineTracker(BundleContext bundleContext) {
        this.tracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)new Customizer());
        this.tracker.open();
    }

    public TestEngine[] getAvailableTestEngines() {
        return (TestEngine[])this.tracker.getTracked().values().stream().map(AtomicReference::get).flatMap(Collection::stream).toArray(TestEngine[]::new);
    }

    @Override
    public void close() {
        this.tracker.close();
    }

    private static class Customizer
    implements BundleTrackerCustomizer<AtomicReference<Set<TestEngine>>> {
        private Customizer() {
        }

        public AtomicReference<Set<TestEngine>> addingBundle(Bundle bundle, BundleEvent event) {
            return new AtomicReference<Set<TestEngine>>(Customizer.getTestEnginesForBundle(bundle));
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, AtomicReference<Set<TestEngine>> testEngines) {
            testEngines.set(Customizer.getTestEnginesForBundle(bundle));
        }

        public void removedBundle(Bundle bundle, BundleEvent event, AtomicReference<Set<TestEngine>> testEngines) {
            testEngines.set(Collections.emptySet());
        }

        @NotNull
        private static Set<TestEngine> getTestEnginesForBundle(Bundle bundle) {
            HashSet<TestEngine> testEngines = new HashSet<TestEngine>();
            ServiceLoader.load(TestEngine.class, ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader()).forEach(testEngine -> {
                LOG.info("Found TestEngine '{}' in bundle '{}'", (Object)testEngine.getId(), (Object)bundle.getSymbolicName());
                testEngines.add((TestEngine)testEngine);
            });
            return testEngines;
        }
    }
}

