/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.junit.Activator;
import org.apache.sling.junit.impl.ServiceGetter;
import org.apache.sling.junit.rules.TeleporterRule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

class ServerSideTeleporter
extends TeleporterRule {
    private final List<ServiceGetter<?>> serviceGettersToClose = new ArrayList();
    private final BundleContext bundleContext = Activator.getBundleContext();
    private final Bundle bundleUnderTest;
    private static final int WAITFOR_SERVICE_TIMEOUT_DEFAULT_SECONDS = 10;

    ServerSideTeleporter(Class<?> classUnderTest) {
        if (this.bundleContext == null) {
            throw new IllegalStateException("Null BundleContext, should not happen when this class is used");
        }
        Bundle bundle = FrameworkUtil.getBundle(classUnderTest);
        if (bundle == null) {
            bundle = this.bundleContext.getBundle();
        }
        this.bundleUnderTest = bundle;
    }

    @Override
    protected void after() {
        super.after();
        for (ServiceGetter<?> serviceGetter : this.serviceGettersToClose) {
            if (serviceGetter == null) continue;
            serviceGetter.close();
        }
    }

    @Override
    public <T> T getService(Class<T> serviceClass, String ldapFilter) {
        String configuredTimeout = (String)this.bundleUnderTest.getHeaders().get("Sling-Test-WaitForService-Timeout");
        if (configuredTimeout == null) {
            configuredTimeout = Integer.toString(10);
        }
        long timeout = Integer.parseInt(configuredTimeout) * 1000;
        try {
            T service = this.getServiceInternal(serviceClass, ldapFilter, timeout);
            if (service != null) {
                return service;
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("unable to get a service reference before timeout, class=" + serviceClass.getName() + ", filter='" + ldapFilter + "'", e);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid syntax for argument ldapFilter", e);
        }
        throw new IllegalStateException("unable to get a service reference, class=" + serviceClass.getName() + ", filter='" + ldapFilter + "'");
    }

    private <T> T getServiceInternal(Class<T> serviceClass, String ldapFilter, long timeoutMs) throws InterruptedException, InvalidSyntaxException {
        ServiceGetter<T> serviceGetter = ServiceGetter.create(this.bundleContext, serviceClass, ldapFilter);
        this.serviceGettersToClose.add(serviceGetter);
        return serviceGetter.getService(timeoutMs);
    }
}

