/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import java.lang.reflect.Field;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.adapter.SlingAdaptable;

final class AdaptableUtil {
    private AdaptableUtil() {
    }

    public static <T> T adaptToWithoutCaching(Object adaptable, Class<T> type) {
        AdapterManager adapterManager = AdaptableUtil.getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return (T)adapterManager.getAdapter(adaptable, type);
    }

    private static AdapterManager getAdapterManager() {
        try {
            Field adapterManagerStaticField = SlingAdaptable.class.getDeclaredField("ADAPTER_MANAGER");
            adapterManagerStaticField.setAccessible(true);
            return (AdapterManager)adapterManagerStaticField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
            throw new RuntimeException("Unable to get AdapterManager instance from SlingAdaptable via reflection.", ex);
        }
    }
}

