/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DefaultAction;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class IPRule
extends Rule {
    private Pattern allowedIP;
    private String exactPath;
    private Pattern path;
    private boolean useExactPath = false;
    private String ipHeader;

    public IPRule(String id, Pattern allowedIP, Pattern path, String ipHeader) {
        this.allowedIP = allowedIP;
        this.path = path;
        this.useExactPath = false;
        this.ipHeader = ipHeader;
        this.setId(id);
    }

    public IPRule(String id, Pattern allowedIP, String exactPath) {
        this.path = null;
        this.exactPath = exactPath;
        this.useExactPath = true;
        this.setId(id);
    }

    @Override
    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        String uri = request.getRequestURI();
        if (!this.useExactPath && this.path.matcher(uri).matches() || this.useExactPath && this.exactPath.equals(uri)) {
            String sourceIP = request.getRemoteAddr() + "";
            if (this.ipHeader != null) {
                sourceIP = request.getHeader(this.ipHeader);
            }
            if (!this.allowedIP.matcher(sourceIP).matches()) {
                this.log(request, "IP not allowed to access URI '" + uri + "'");
                return new DefaultAction();
            }
        }
        return new DoNothingAction();
    }
}

