/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.test.context.util.TestContextFailureHandler;

public abstract class TestContextSpringFactoriesUtils {
    private static final Log logger = LogFactory.getLog(TestContextSpringFactoriesUtils.class);

    private TestContextSpringFactoriesUtils() {
    }

    public static <T> List<T> loadFactoryImplementations(Class<T> factoryType) {
        SpringFactoriesLoader loader = SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)TestContextSpringFactoriesUtils.class.getClassLoader());
        List implementations = loader.load(factoryType, (SpringFactoriesLoader.FailureHandler)new TestContextFailureHandler());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Loaded %s implementations from location [%s]: %s".formatted(factoryType.getSimpleName(), "META-INF/spring.factories", TestContextSpringFactoriesUtils.classNames(implementations)));
        }
        return Collections.unmodifiableList(implementations);
    }

    private static List<String> classNames(Collection<?> components) {
        return components.stream().map(Object::getClass).map(Class::getName).toList();
    }
}

