/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.spring;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.fulcrum.spring.BeanFactoryServiceManager;
import org.apache.fulcrum.spring.SpringFrameworkService;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SpringFrameworkServiceImpl
extends AbstractLogEnabled
implements SpringFrameworkService,
Configurable,
Initializable,
Disposable,
ServiceManager {
    private String[] configLocations = new String[0];
    private AbstractApplicationContext ctx;
    private BeanFactoryServiceManager beanFactoryServiceManager;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] configLocationConfigurationList = configuration.getChild("configurations").getChildren("configuration");
        this.configLocations = new String[configLocationConfigurationList.length];
        for (int i = 0; i < this.configLocations.length; ++i) {
            this.configLocations[i] = configLocationConfigurationList[i].getValue();
        }
        if (this.configLocations.length == 0) {
            String msg = "No configuration files for the Spring container are defined";
            throw new ConfigurationException(msg);
        }
    }

    public void initialize() throws Exception {
        this.ctx = new FileSystemXmlApplicationContext(this.configLocations);
        this.beanFactoryServiceManager = new BeanFactoryServiceManager((BeanFactory)this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (Exception e) {
                String msg = "Failed to dispose the Spring service";
                this.getLogger().error(msg, (Throwable)e);
            }
            finally {
                this.ctx = null;
            }
        }
        this.beanFactoryServiceManager = null;
    }

    public AbstractApplicationContext getAbstractApplicationContext() {
        return this.ctx;
    }

    public Object lookup(String key) throws ServiceException {
        if (this.beanFactoryServiceManager == null) {
            throw new RuntimeException("The SpringFrameworkService is not yet initialized");
        }
        return this.beanFactoryServiceManager.lookup(key);
    }

    public boolean hasService(String key) {
        if (this.beanFactoryServiceManager == null) {
            throw new RuntimeException("The SpringFrameworkService is not yet initialized");
        }
        return this.beanFactoryServiceManager.hasService(key);
    }

    public void release(Object o) {
        if (this.beanFactoryServiceManager == null) {
            throw new RuntimeException("The SpringFrameworkService is not yet initialized");
        }
        this.beanFactoryServiceManager.release(o);
    }
}

