/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.internal.uima.util;

import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.deployment.AEDeploymentMetaData;
import org.apache.uima.aae.deployment.AsyncAEErrorConfiguration;
import org.apache.uima.aae.deployment.GetMetadataErrors;
import org.apache.uima.aae.deployment.RemoteAEDeploymentMetaData;
import org.apache.uima.aae.deployment.impl.AsyncAggregateErrorConfiguration_Impl;
import org.apache.uima.aae.deployment.impl.DeploymentMetaData_Impl;
import org.apache.uima.aae.deployment.impl.GetMetadataErrors_Impl;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.util.InvalidXMLException;

public class AETreeBuilder {
    public static Import createImport(String descriptor, boolean byLocation) {
        Import imp = (Import)UIMAFramework.getResourceSpecifierFactory().createObject(Import.class);
        if (byLocation) {
            imp.setLocation(descriptor);
        } else {
            imp.setName(descriptor);
        }
        return imp;
    }

    public static AEDeploymentMetaData createAEDeploymentMetaData(RemoteAEDeploymentMetaData remoteMetaData) {
        ResourceSpecifierFactory factory = UIMAFramework.getResourceSpecifierFactory();
        AEDeploymentMetaData metaData = (AEDeploymentMetaData)factory.createObject(AEDeploymentMetaData.class);
        metaData.setParent(remoteMetaData.getParent());
        metaData.setKey(remoteMetaData.getKey());
        try {
            metaData.setResourceSpecifier(remoteMetaData.getResourceSpecifier(), null, false);
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        metaData.setCasMultiplierPoolSize(remoteMetaData.getCasMultiplierPoolSize());
        metaData.setAsyncAEErrorConfiguration(remoteMetaData.getAsyncAEErrorConfiguration().clone());
        metaData.getAsyncAEErrorConfiguration().getGetMetadataErrors().setTimeout(0);
        return metaData;
    }

    public static RemoteAEDeploymentMetaData createRemoteAEDeploymentMetaData(AEDeploymentMetaData metaData) {
        ResourceSpecifierFactory factory = UIMAFramework.getResourceSpecifierFactory();
        RemoteAEDeploymentMetaData remoteMetaData = (RemoteAEDeploymentMetaData)factory.createObject(RemoteAEDeploymentMetaData.class);
        remoteMetaData.setParent(metaData.getParent());
        remoteMetaData.setKey(metaData.getKey());
        remoteMetaData.setCasMultiplierPoolSize(metaData.getCasMultiplierPoolSize());
        remoteMetaData.setRemoteReplyQueueScaleout(-1);
        try {
            remoteMetaData.setResourceSpecifier(metaData.getResourceSpecifier(), null, false);
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        AsyncAEErrorConfiguration aggErrorConfig = null;
        AsyncAEErrorConfiguration errorConfig = metaData.getAsyncAEErrorConfiguration();
        if (errorConfig instanceof AsyncAggregateErrorConfiguration_Impl) {
            aggErrorConfig = errorConfig.clone();
        } else {
            aggErrorConfig = new AsyncAggregateErrorConfiguration_Impl();
            aggErrorConfig.setGetMetadataErrors((GetMetadataErrors)new GetMetadataErrors_Impl(errorConfig));
            aggErrorConfig.setProcessCasErrors(errorConfig.getProcessCasErrors().clone(aggErrorConfig));
            aggErrorConfig.setCollectionProcessCompleteErrors(errorConfig.getCollectionProcessCompleteErrors().clone(aggErrorConfig));
        }
        remoteMetaData.setErrorConfiguration(aggErrorConfig);
        errorConfig.sParentObject((DeploymentMetaData_Impl)remoteMetaData);
        aggErrorConfig.getGetMetadataErrors().setTimeout(60000);
        return remoteMetaData;
    }

    public static boolean isCASMultiplier(AnalysisEngineDescription ae) {
        return AETreeBuilder.isCASMultiplier(ae.getAnalysisEngineMetaData());
    }

    public static boolean isCASMultiplier(AnalysisEngineMetaData meta) {
        OperationalProperties op = meta.getOperationalProperties();
        if (op != null) {
            return op.getOutputsNewCASes();
        }
        return false;
    }
}

