/**
 * @file
 *
 * @brief Unicode character range checking
 *
 * this module exports interfaces for the character
 *               range validation APIs
 */

#ifndef __XML_CHVALID_H__
#define __XML_CHVALID_H__

#include <libxml/xmlversion.h>
#include <libxml/xmlstring.h>

#ifdef __cplusplus
extern "C" {
#endif

/** @cond ignore */

/*
 * Define our typedefs and structures
 *
 */
typedef struct _xmlChSRange xmlChSRange;
typedef xmlChSRange *xmlChSRangePtr;
struct _xmlChSRange {
    unsigned short	low;
    unsigned short	high;
};

typedef struct _xmlChLRange xmlChLRange;
typedef xmlChLRange *xmlChLRangePtr;
struct _xmlChLRange {
    unsigned int	low;
    unsigned int	high;
};

typedef struct _xmlChRangeGroup xmlChRangeGroup;
typedef xmlChRangeGroup *xmlChRangeGroupPtr;
struct _xmlChRangeGroup {
    int			nbShortRange;
    int			nbLongRange;
    const xmlChSRange	*shortRange;	/* points to an array of ranges */
    const xmlChLRange	*longRange;
};

XMLPUBVAR const xmlChRangeGroup xmlIsBaseCharGroup;
XMLPUBVAR const xmlChRangeGroup xmlIsCharGroup;
XMLPUBVAR const xmlChRangeGroup xmlIsCombiningGroup;
XMLPUBVAR const xmlChRangeGroup xmlIsDigitGroup;
XMLPUBVAR const xmlChRangeGroup xmlIsExtenderGroup;
XMLPUBVAR const xmlChRangeGroup xmlIsIdeographicGroup;
XMLPUBVAR const unsigned char xmlIsPubidChar_tab[256];

/**
 * Range checking routine
 */
XMLPUBFUN int
		xmlCharInRange(unsigned int val, const xmlChRangeGroup *group);

/** @endcond */

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsBaseChar_ch(c)	(((0x41 <= (c)) && ((c) <= 0x5a)) || \
				 ((0x61 <= (c)) && ((c) <= 0x7a)) || \
				 ((0xc0 <= (c)) && ((c) <= 0xd6)) || \
				 ((0xd8 <= (c)) && ((c) <= 0xf6)) || \
				  (0xf8 <= (c)))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsBaseCharQ(c)	(((c) < 0x100) ? \
				 xmlIsBaseChar_ch((c)) : \
				 xmlCharInRange((c), &xmlIsBaseCharGroup))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsBlank_ch(c)	(((c) == 0x20) || \
				 ((0x9 <= (c)) && ((c) <= 0xa)) || \
				 ((c) == 0xd))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsBlankQ(c)		(((c) < 0x100) ? \
				 xmlIsBlank_ch((c)) : 0)


/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsChar_ch(c)		(((0x9 <= (c)) && ((c) <= 0xa)) || \
				 ((c) == 0xd) || \
				  (0x20 <= (c)))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsCharQ(c)		(((c) < 0x100) ? \
				 xmlIsChar_ch((c)) :\
				(((0x100 <= (c)) && ((c) <= 0xd7ff)) || \
				 ((0xe000 <= (c)) && ((c) <= 0xfffd)) || \
				 ((0x10000 <= (c)) && ((c) <= 0x10ffff))))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsCombiningQ(c)	(((c) < 0x100) ? \
				 0 : \
				 xmlCharInRange((c), &xmlIsCombiningGroup))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsDigit_ch(c)	(((0x30 <= (c)) && ((c) <= 0x39)))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsDigitQ(c)		(((c) < 0x100) ? \
				 xmlIsDigit_ch((c)) : \
				 xmlCharInRange((c), &xmlIsDigitGroup))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsExtender_ch(c)	(((c) == 0xb7))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsExtenderQ(c)	(((c) < 0x100) ? \
				 xmlIsExtender_ch((c)) : \
				 xmlCharInRange((c), &xmlIsExtenderGroup))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsIdeographicQ(c)	(((c) < 0x100) ? \
				 0 :\
				(((0x4e00 <= (c)) && ((c) <= 0x9fa5)) || \
				 ((c) == 0x3007) || \
				 ((0x3021 <= (c)) && ((c) <= 0x3029))))

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsPubidChar_ch(c)	(xmlIsPubidChar_tab[(c)])

/**
 * Automatically generated by genChRanges.py
 *
 * @param c  char to validate
 */
#define xmlIsPubidCharQ(c)	(((c) < 0x100) ? \
				 xmlIsPubidChar_ch((c)) : 0)

XML_DEPRECATED
XMLPUBFUN int
		xmlIsBaseChar(unsigned int ch);
XML_DEPRECATED
XMLPUBFUN int
		xmlIsBlank(unsigned int ch);
XML_DEPRECATED
XMLPUBFUN int
		xmlIsChar(unsigned int ch);
XML_DEPRECATED
XMLPUBFUN int
		xmlIsCombining(unsigned int ch);
XML_DEPRECATED
XMLPUBFUN int
		xmlIsDigit(unsigned int ch);
XML_DEPRECATED
XMLPUBFUN int
		xmlIsExtender(unsigned int ch);
XML_DEPRECATED
XMLPUBFUN int
		xmlIsIdeographic(unsigned int ch);
XML_DEPRECATED
XMLPUBFUN int
		xmlIsPubidChar(unsigned int ch);

#ifdef __cplusplus
}
#endif
#endif /* __XML_CHVALID_H__ */
