/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.sql.type.SqlTypeCoercionRule;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.implicit.TypeCoercionFactory;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SqlValidator", generator="Immutables")
final class ImmutableSqlValidator {
    private ImmutableSqlValidator() {
    }

    @CheckReturnValue
    @Generated(from="SqlValidator.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements SqlValidator.Config {
        private final boolean callRewrite;
        private final NullCollation defaultNullCollation;
        private final boolean columnReferenceExpansion;
        private final boolean identifierExpansion;
        private final boolean embeddedQuery;
        private final boolean lenientOperatorLookup;
        private final boolean nakedMeasuresInNonAggregateQuery;
        private final boolean nakedMeasuresInAggregateQuery;
        private final boolean typeCoercionEnabled;
        private final TypeCoercionFactory typeCoercionFactory;
        private final @org.checkerframework.checker.nullness.qual.Nullable SqlTypeCoercionRule typeCoercionRules;
        private final SqlConformance conformance;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Config(Builder builder) {
            this.typeCoercionFactory = builder.typeCoercionFactory;
            this.typeCoercionRules = builder.typeCoercionRules;
            if (builder.callRewriteIsSet()) {
                this.initShim.withCallRewrite(builder.callRewrite);
            }
            if (builder.defaultNullCollation != null) {
                this.initShim.withDefaultNullCollation(builder.defaultNullCollation);
            }
            if (builder.columnReferenceExpansionIsSet()) {
                this.initShim.withColumnReferenceExpansion(builder.columnReferenceExpansion);
            }
            if (builder.identifierExpansionIsSet()) {
                this.initShim.withIdentifierExpansion(builder.identifierExpansion);
            }
            if (builder.embeddedQueryIsSet()) {
                this.initShim.withEmbeddedQuery(builder.embeddedQuery);
            }
            if (builder.lenientOperatorLookupIsSet()) {
                this.initShim.withLenientOperatorLookup(builder.lenientOperatorLookup);
            }
            if (builder.nakedMeasuresInNonAggregateQueryIsSet()) {
                this.initShim.withNakedMeasuresInNonAggregateQuery(builder.nakedMeasuresInNonAggregateQuery);
            }
            if (builder.nakedMeasuresInAggregateQueryIsSet()) {
                this.initShim.withNakedMeasuresInAggregateQuery(builder.nakedMeasuresInAggregateQuery);
            }
            if (builder.typeCoercionEnabledIsSet()) {
                this.initShim.withTypeCoercionEnabled(builder.typeCoercionEnabled);
            }
            if (builder.conformance != null) {
                this.initShim.withConformance(builder.conformance);
            }
            this.callRewrite = this.initShim.callRewrite();
            this.defaultNullCollation = this.initShim.defaultNullCollation();
            this.columnReferenceExpansion = this.initShim.columnReferenceExpansion();
            this.identifierExpansion = this.initShim.identifierExpansion();
            this.embeddedQuery = this.initShim.embeddedQuery();
            this.lenientOperatorLookup = this.initShim.lenientOperatorLookup();
            this.nakedMeasuresInNonAggregateQuery = this.initShim.nakedMeasuresInNonAggregateQuery();
            this.nakedMeasuresInAggregateQuery = this.initShim.nakedMeasuresInAggregateQuery();
            this.typeCoercionEnabled = this.initShim.typeCoercionEnabled();
            this.conformance = this.initShim.conformance();
            this.initShim = null;
        }

        private Config(boolean callRewrite, NullCollation defaultNullCollation, boolean columnReferenceExpansion, boolean identifierExpansion, boolean embeddedQuery, boolean lenientOperatorLookup, boolean nakedMeasuresInNonAggregateQuery, boolean nakedMeasuresInAggregateQuery, boolean typeCoercionEnabled, TypeCoercionFactory typeCoercionFactory, @org.checkerframework.checker.nullness.qual.Nullable SqlTypeCoercionRule typeCoercionRules, SqlConformance conformance) {
            this.callRewrite = callRewrite;
            this.defaultNullCollation = defaultNullCollation;
            this.columnReferenceExpansion = columnReferenceExpansion;
            this.identifierExpansion = identifierExpansion;
            this.embeddedQuery = embeddedQuery;
            this.lenientOperatorLookup = lenientOperatorLookup;
            this.nakedMeasuresInNonAggregateQuery = nakedMeasuresInNonAggregateQuery;
            this.nakedMeasuresInAggregateQuery = nakedMeasuresInAggregateQuery;
            this.typeCoercionEnabled = typeCoercionEnabled;
            this.typeCoercionFactory = typeCoercionFactory;
            this.typeCoercionRules = typeCoercionRules;
            this.conformance = conformance;
            this.initShim = null;
        }

        private boolean callRewriteInitialize() {
            return SqlValidator.Config.super.callRewrite();
        }

        private NullCollation defaultNullCollationInitialize() {
            return SqlValidator.Config.super.defaultNullCollation();
        }

        private boolean columnReferenceExpansionInitialize() {
            return SqlValidator.Config.super.columnReferenceExpansion();
        }

        private boolean identifierExpansionInitialize() {
            return SqlValidator.Config.super.identifierExpansion();
        }

        private boolean embeddedQueryInitialize() {
            return SqlValidator.Config.super.embeddedQuery();
        }

        private boolean lenientOperatorLookupInitialize() {
            return SqlValidator.Config.super.lenientOperatorLookup();
        }

        private boolean nakedMeasuresInNonAggregateQueryInitialize() {
            return SqlValidator.Config.super.nakedMeasuresInNonAggregateQuery();
        }

        private boolean nakedMeasuresInAggregateQueryInitialize() {
            return SqlValidator.Config.super.nakedMeasuresInAggregateQuery();
        }

        private boolean typeCoercionEnabledInitialize() {
            return SqlValidator.Config.super.typeCoercionEnabled();
        }

        private SqlConformance conformanceInitialize() {
            return SqlValidator.Config.super.conformance();
        }

        @Override
        public boolean callRewrite() {
            InitShim shim = this.initShim;
            return shim != null ? shim.callRewrite() : this.callRewrite;
        }

        @Override
        public NullCollation defaultNullCollation() {
            InitShim shim = this.initShim;
            return shim != null ? shim.defaultNullCollation() : this.defaultNullCollation;
        }

        @Override
        public boolean columnReferenceExpansion() {
            InitShim shim = this.initShim;
            return shim != null ? shim.columnReferenceExpansion() : this.columnReferenceExpansion;
        }

        @Override
        public boolean identifierExpansion() {
            InitShim shim = this.initShim;
            return shim != null ? shim.identifierExpansion() : this.identifierExpansion;
        }

        @Override
        public boolean embeddedQuery() {
            InitShim shim = this.initShim;
            return shim != null ? shim.embeddedQuery() : this.embeddedQuery;
        }

        @Override
        public boolean lenientOperatorLookup() {
            InitShim shim = this.initShim;
            return shim != null ? shim.lenientOperatorLookup() : this.lenientOperatorLookup;
        }

        @Override
        public boolean nakedMeasuresInNonAggregateQuery() {
            InitShim shim = this.initShim;
            return shim != null ? shim.nakedMeasuresInNonAggregateQuery() : this.nakedMeasuresInNonAggregateQuery;
        }

        @Override
        public boolean nakedMeasuresInAggregateQuery() {
            InitShim shim = this.initShim;
            return shim != null ? shim.nakedMeasuresInAggregateQuery() : this.nakedMeasuresInAggregateQuery;
        }

        @Override
        public boolean typeCoercionEnabled() {
            InitShim shim = this.initShim;
            return shim != null ? shim.typeCoercionEnabled() : this.typeCoercionEnabled;
        }

        @Override
        public TypeCoercionFactory typeCoercionFactory() {
            return this.typeCoercionFactory;
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable SqlTypeCoercionRule typeCoercionRules() {
            return this.typeCoercionRules;
        }

        @Override
        public SqlConformance conformance() {
            InitShim shim = this.initShim;
            return shim != null ? shim.conformance() : this.conformance;
        }

        @Override
        public final Config withCallRewrite(boolean value) {
            if (this.callRewrite == value) {
                return this;
            }
            return new Config(value, this.defaultNullCollation, this.columnReferenceExpansion, this.identifierExpansion, this.embeddedQuery, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, this.typeCoercionFactory, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withDefaultNullCollation(NullCollation value) {
            if (this.defaultNullCollation == value) {
                return this;
            }
            NullCollation newValue = Objects.requireNonNull(value, "defaultNullCollation");
            if (this.defaultNullCollation.equals((Object)newValue)) {
                return this;
            }
            return new Config(this.callRewrite, newValue, this.columnReferenceExpansion, this.identifierExpansion, this.embeddedQuery, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, this.typeCoercionFactory, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withColumnReferenceExpansion(boolean value) {
            if (this.columnReferenceExpansion == value) {
                return this;
            }
            return new Config(this.callRewrite, this.defaultNullCollation, value, this.identifierExpansion, this.embeddedQuery, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, this.typeCoercionFactory, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withIdentifierExpansion(boolean value) {
            if (this.identifierExpansion == value) {
                return this;
            }
            return new Config(this.callRewrite, this.defaultNullCollation, this.columnReferenceExpansion, value, this.embeddedQuery, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, this.typeCoercionFactory, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withEmbeddedQuery(boolean value) {
            if (this.embeddedQuery == value) {
                return this;
            }
            return new Config(this.callRewrite, this.defaultNullCollation, this.columnReferenceExpansion, this.identifierExpansion, value, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, this.typeCoercionFactory, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withLenientOperatorLookup(boolean value) {
            if (this.lenientOperatorLookup == value) {
                return this;
            }
            return new Config(this.callRewrite, this.defaultNullCollation, this.columnReferenceExpansion, this.identifierExpansion, this.embeddedQuery, value, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, this.typeCoercionFactory, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withNakedMeasuresInNonAggregateQuery(boolean value) {
            if (this.nakedMeasuresInNonAggregateQuery == value) {
                return this;
            }
            return new Config(this.callRewrite, this.defaultNullCollation, this.columnReferenceExpansion, this.identifierExpansion, this.embeddedQuery, this.lenientOperatorLookup, value, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, this.typeCoercionFactory, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withNakedMeasuresInAggregateQuery(boolean value) {
            if (this.nakedMeasuresInAggregateQuery == value) {
                return this;
            }
            return new Config(this.callRewrite, this.defaultNullCollation, this.columnReferenceExpansion, this.identifierExpansion, this.embeddedQuery, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, value, this.typeCoercionEnabled, this.typeCoercionFactory, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withTypeCoercionEnabled(boolean value) {
            if (this.typeCoercionEnabled == value) {
                return this;
            }
            return new Config(this.callRewrite, this.defaultNullCollation, this.columnReferenceExpansion, this.identifierExpansion, this.embeddedQuery, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, value, this.typeCoercionFactory, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withTypeCoercionFactory(TypeCoercionFactory value) {
            if (this.typeCoercionFactory == value) {
                return this;
            }
            TypeCoercionFactory newValue = Objects.requireNonNull(value, "typeCoercionFactory");
            return new Config(this.callRewrite, this.defaultNullCollation, this.columnReferenceExpansion, this.identifierExpansion, this.embeddedQuery, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, newValue, this.typeCoercionRules, this.conformance);
        }

        @Override
        public final Config withTypeCoercionRules(@org.checkerframework.checker.nullness.qual.Nullable SqlTypeCoercionRule value) {
            if (this.typeCoercionRules == value) {
                return this;
            }
            return new Config(this.callRewrite, this.defaultNullCollation, this.columnReferenceExpansion, this.identifierExpansion, this.embeddedQuery, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, this.typeCoercionFactory, value, this.conformance);
        }

        @Override
        public final Config withConformance(SqlConformance value) {
            if (this.conformance == value) {
                return this;
            }
            SqlConformance newValue = Objects.requireNonNull(value, "conformance");
            return new Config(this.callRewrite, this.defaultNullCollation, this.columnReferenceExpansion, this.identifierExpansion, this.embeddedQuery, this.lenientOperatorLookup, this.nakedMeasuresInNonAggregateQuery, this.nakedMeasuresInAggregateQuery, this.typeCoercionEnabled, this.typeCoercionFactory, this.typeCoercionRules, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.callRewrite == another.callRewrite && this.defaultNullCollation.equals((Object)another.defaultNullCollation) && this.columnReferenceExpansion == another.columnReferenceExpansion && this.identifierExpansion == another.identifierExpansion && this.embeddedQuery == another.embeddedQuery && this.lenientOperatorLookup == another.lenientOperatorLookup && this.nakedMeasuresInNonAggregateQuery == another.nakedMeasuresInNonAggregateQuery && this.nakedMeasuresInAggregateQuery == another.nakedMeasuresInAggregateQuery && this.typeCoercionEnabled == another.typeCoercionEnabled && this.typeCoercionFactory.equals(another.typeCoercionFactory) && Objects.equals(this.typeCoercionRules, another.typeCoercionRules) && this.conformance.equals(another.conformance);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Booleans.hashCode((boolean)this.callRewrite);
            h += (h << 5) + this.defaultNullCollation.hashCode();
            h += (h << 5) + Booleans.hashCode((boolean)this.columnReferenceExpansion);
            h += (h << 5) + Booleans.hashCode((boolean)this.identifierExpansion);
            h += (h << 5) + Booleans.hashCode((boolean)this.embeddedQuery);
            h += (h << 5) + Booleans.hashCode((boolean)this.lenientOperatorLookup);
            h += (h << 5) + Booleans.hashCode((boolean)this.nakedMeasuresInNonAggregateQuery);
            h += (h << 5) + Booleans.hashCode((boolean)this.nakedMeasuresInAggregateQuery);
            h += (h << 5) + Booleans.hashCode((boolean)this.typeCoercionEnabled);
            h += (h << 5) + this.typeCoercionFactory.hashCode();
            h += (h << 5) + Objects.hashCode(this.typeCoercionRules);
            h += (h << 5) + this.conformance.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Config").omitNullValues().add("callRewrite", this.callRewrite).add("defaultNullCollation", (Object)this.defaultNullCollation).add("columnReferenceExpansion", this.columnReferenceExpansion).add("identifierExpansion", this.identifierExpansion).add("embeddedQuery", this.embeddedQuery).add("lenientOperatorLookup", this.lenientOperatorLookup).add("nakedMeasuresInNonAggregateQuery", this.nakedMeasuresInNonAggregateQuery).add("nakedMeasuresInAggregateQuery", this.nakedMeasuresInAggregateQuery).add("typeCoercionEnabled", this.typeCoercionEnabled).add("typeCoercionFactory", (Object)this.typeCoercionFactory).add("typeCoercionRules", (Object)this.typeCoercionRules).add("conformance", (Object)this.conformance).toString();
        }

        public static Config copyOf(SqlValidator.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SqlValidator.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TYPE_COERCION_FACTORY = 1L;
            private static final long OPT_BIT_CALL_REWRITE = 1L;
            private static final long OPT_BIT_COLUMN_REFERENCE_EXPANSION = 2L;
            private static final long OPT_BIT_IDENTIFIER_EXPANSION = 4L;
            private static final long OPT_BIT_EMBEDDED_QUERY = 8L;
            private static final long OPT_BIT_LENIENT_OPERATOR_LOOKUP = 16L;
            private static final long OPT_BIT_NAKED_MEASURES_IN_NON_AGGREGATE_QUERY = 32L;
            private static final long OPT_BIT_NAKED_MEASURES_IN_AGGREGATE_QUERY = 64L;
            private static final long OPT_BIT_TYPE_COERCION_ENABLED = 128L;
            private long initBits = 1L;
            private long optBits;
            private boolean callRewrite;
            @Nullable
            private NullCollation defaultNullCollation;
            private boolean columnReferenceExpansion;
            private boolean identifierExpansion;
            private boolean embeddedQuery;
            private boolean lenientOperatorLookup;
            private boolean nakedMeasuresInNonAggregateQuery;
            private boolean nakedMeasuresInAggregateQuery;
            private boolean typeCoercionEnabled;
            @Nullable
            private TypeCoercionFactory typeCoercionFactory;
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable SqlTypeCoercionRule typeCoercionRules;
            @Nullable
            private SqlConformance conformance;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(SqlValidator.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.withCallRewrite(instance.callRewrite());
                this.withDefaultNullCollation(instance.defaultNullCollation());
                this.withColumnReferenceExpansion(instance.columnReferenceExpansion());
                this.withIdentifierExpansion(instance.identifierExpansion());
                this.withEmbeddedQuery(instance.embeddedQuery());
                this.withLenientOperatorLookup(instance.lenientOperatorLookup());
                this.withNakedMeasuresInNonAggregateQuery(instance.nakedMeasuresInNonAggregateQuery());
                this.withNakedMeasuresInAggregateQuery(instance.nakedMeasuresInAggregateQuery());
                this.withTypeCoercionEnabled(instance.typeCoercionEnabled());
                this.withTypeCoercionFactory(instance.typeCoercionFactory());
                @org.checkerframework.checker.nullness.qual.Nullable SqlTypeCoercionRule typeCoercionRulesValue = instance.typeCoercionRules();
                if (typeCoercionRulesValue != null) {
                    this.withTypeCoercionRules(typeCoercionRulesValue);
                }
                this.withConformance(instance.conformance());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withCallRewrite(boolean callRewrite) {
                this.callRewrite = callRewrite;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDefaultNullCollation(NullCollation defaultNullCollation) {
                this.defaultNullCollation = Objects.requireNonNull(defaultNullCollation, "defaultNullCollation");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withColumnReferenceExpansion(boolean columnReferenceExpansion) {
                this.columnReferenceExpansion = columnReferenceExpansion;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withIdentifierExpansion(boolean identifierExpansion) {
                this.identifierExpansion = identifierExpansion;
                this.optBits |= 4L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withEmbeddedQuery(boolean embeddedQuery) {
                this.embeddedQuery = embeddedQuery;
                this.optBits |= 8L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withLenientOperatorLookup(boolean lenientOperatorLookup) {
                this.lenientOperatorLookup = lenientOperatorLookup;
                this.optBits |= 0x10L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withNakedMeasuresInNonAggregateQuery(boolean nakedMeasuresInNonAggregateQuery) {
                this.nakedMeasuresInNonAggregateQuery = nakedMeasuresInNonAggregateQuery;
                this.optBits |= 0x20L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withNakedMeasuresInAggregateQuery(boolean nakedMeasuresInAggregateQuery) {
                this.nakedMeasuresInAggregateQuery = nakedMeasuresInAggregateQuery;
                this.optBits |= 0x40L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withTypeCoercionEnabled(boolean typeCoercionEnabled) {
                this.typeCoercionEnabled = typeCoercionEnabled;
                this.optBits |= 0x80L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withTypeCoercionFactory(TypeCoercionFactory typeCoercionFactory) {
                this.typeCoercionFactory = Objects.requireNonNull(typeCoercionFactory, "typeCoercionFactory");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withTypeCoercionRules(@org.checkerframework.checker.nullness.qual.Nullable SqlTypeCoercionRule typeCoercionRules) {
                this.typeCoercionRules = typeCoercionRules;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withConformance(SqlConformance conformance) {
                this.conformance = Objects.requireNonNull(conformance, "conformance");
                return this;
            }

            public Config build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Config(this);
            }

            private boolean callRewriteIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean columnReferenceExpansionIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private boolean identifierExpansionIsSet() {
                return (this.optBits & 4L) != 0L;
            }

            private boolean embeddedQueryIsSet() {
                return (this.optBits & 8L) != 0L;
            }

            private boolean lenientOperatorLookupIsSet() {
                return (this.optBits & 0x10L) != 0L;
            }

            private boolean nakedMeasuresInNonAggregateQueryIsSet() {
                return (this.optBits & 0x20L) != 0L;
            }

            private boolean nakedMeasuresInAggregateQueryIsSet() {
                return (this.optBits & 0x40L) != 0L;
            }

            private boolean typeCoercionEnabledIsSet() {
                return (this.optBits & 0x80L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("typeCoercionFactory");
                }
                return "Cannot build Config, some of required attributes are not set " + attributes;
            }
        }

        @Generated(from="SqlValidator.Config", generator="Immutables")
        private final class InitShim {
            private byte callRewriteBuildStage = 0;
            private boolean callRewrite;
            private byte defaultNullCollationBuildStage = 0;
            private NullCollation defaultNullCollation;
            private byte columnReferenceExpansionBuildStage = 0;
            private boolean columnReferenceExpansion;
            private byte identifierExpansionBuildStage = 0;
            private boolean identifierExpansion;
            private byte embeddedQueryBuildStage = 0;
            private boolean embeddedQuery;
            private byte lenientOperatorLookupBuildStage = 0;
            private boolean lenientOperatorLookup;
            private byte nakedMeasuresInNonAggregateQueryBuildStage = 0;
            private boolean nakedMeasuresInNonAggregateQuery;
            private byte nakedMeasuresInAggregateQueryBuildStage = 0;
            private boolean nakedMeasuresInAggregateQuery;
            private byte typeCoercionEnabledBuildStage = 0;
            private boolean typeCoercionEnabled;
            private byte conformanceBuildStage = 0;
            private SqlConformance conformance;

            private InitShim() {
            }

            boolean callRewrite() {
                if (this.callRewriteBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.callRewriteBuildStage == 0) {
                    this.callRewriteBuildStage = (byte)-1;
                    this.callRewrite = Config.this.callRewriteInitialize();
                    this.callRewriteBuildStage = 1;
                }
                return this.callRewrite;
            }

            void withCallRewrite(boolean callRewrite) {
                this.callRewrite = callRewrite;
                this.callRewriteBuildStage = 1;
            }

            NullCollation defaultNullCollation() {
                if (this.defaultNullCollationBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.defaultNullCollationBuildStage == 0) {
                    this.defaultNullCollationBuildStage = (byte)-1;
                    this.defaultNullCollation = Objects.requireNonNull(Config.this.defaultNullCollationInitialize(), "defaultNullCollation");
                    this.defaultNullCollationBuildStage = 1;
                }
                return this.defaultNullCollation;
            }

            void withDefaultNullCollation(NullCollation defaultNullCollation) {
                this.defaultNullCollation = defaultNullCollation;
                this.defaultNullCollationBuildStage = 1;
            }

            boolean columnReferenceExpansion() {
                if (this.columnReferenceExpansionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.columnReferenceExpansionBuildStage == 0) {
                    this.columnReferenceExpansionBuildStage = (byte)-1;
                    this.columnReferenceExpansion = Config.this.columnReferenceExpansionInitialize();
                    this.columnReferenceExpansionBuildStage = 1;
                }
                return this.columnReferenceExpansion;
            }

            void withColumnReferenceExpansion(boolean columnReferenceExpansion) {
                this.columnReferenceExpansion = columnReferenceExpansion;
                this.columnReferenceExpansionBuildStage = 1;
            }

            boolean identifierExpansion() {
                if (this.identifierExpansionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.identifierExpansionBuildStage == 0) {
                    this.identifierExpansionBuildStage = (byte)-1;
                    this.identifierExpansion = Config.this.identifierExpansionInitialize();
                    this.identifierExpansionBuildStage = 1;
                }
                return this.identifierExpansion;
            }

            void withIdentifierExpansion(boolean identifierExpansion) {
                this.identifierExpansion = identifierExpansion;
                this.identifierExpansionBuildStage = 1;
            }

            boolean embeddedQuery() {
                if (this.embeddedQueryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.embeddedQueryBuildStage == 0) {
                    this.embeddedQueryBuildStage = (byte)-1;
                    this.embeddedQuery = Config.this.embeddedQueryInitialize();
                    this.embeddedQueryBuildStage = 1;
                }
                return this.embeddedQuery;
            }

            void withEmbeddedQuery(boolean embeddedQuery) {
                this.embeddedQuery = embeddedQuery;
                this.embeddedQueryBuildStage = 1;
            }

            boolean lenientOperatorLookup() {
                if (this.lenientOperatorLookupBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.lenientOperatorLookupBuildStage == 0) {
                    this.lenientOperatorLookupBuildStage = (byte)-1;
                    this.lenientOperatorLookup = Config.this.lenientOperatorLookupInitialize();
                    this.lenientOperatorLookupBuildStage = 1;
                }
                return this.lenientOperatorLookup;
            }

            void withLenientOperatorLookup(boolean lenientOperatorLookup) {
                this.lenientOperatorLookup = lenientOperatorLookup;
                this.lenientOperatorLookupBuildStage = 1;
            }

            boolean nakedMeasuresInNonAggregateQuery() {
                if (this.nakedMeasuresInNonAggregateQueryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nakedMeasuresInNonAggregateQueryBuildStage == 0) {
                    this.nakedMeasuresInNonAggregateQueryBuildStage = (byte)-1;
                    this.nakedMeasuresInNonAggregateQuery = Config.this.nakedMeasuresInNonAggregateQueryInitialize();
                    this.nakedMeasuresInNonAggregateQueryBuildStage = 1;
                }
                return this.nakedMeasuresInNonAggregateQuery;
            }

            void withNakedMeasuresInNonAggregateQuery(boolean nakedMeasuresInNonAggregateQuery) {
                this.nakedMeasuresInNonAggregateQuery = nakedMeasuresInNonAggregateQuery;
                this.nakedMeasuresInNonAggregateQueryBuildStage = 1;
            }

            boolean nakedMeasuresInAggregateQuery() {
                if (this.nakedMeasuresInAggregateQueryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nakedMeasuresInAggregateQueryBuildStage == 0) {
                    this.nakedMeasuresInAggregateQueryBuildStage = (byte)-1;
                    this.nakedMeasuresInAggregateQuery = Config.this.nakedMeasuresInAggregateQueryInitialize();
                    this.nakedMeasuresInAggregateQueryBuildStage = 1;
                }
                return this.nakedMeasuresInAggregateQuery;
            }

            void withNakedMeasuresInAggregateQuery(boolean nakedMeasuresInAggregateQuery) {
                this.nakedMeasuresInAggregateQuery = nakedMeasuresInAggregateQuery;
                this.nakedMeasuresInAggregateQueryBuildStage = 1;
            }

            boolean typeCoercionEnabled() {
                if (this.typeCoercionEnabledBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.typeCoercionEnabledBuildStage == 0) {
                    this.typeCoercionEnabledBuildStage = (byte)-1;
                    this.typeCoercionEnabled = Config.this.typeCoercionEnabledInitialize();
                    this.typeCoercionEnabledBuildStage = 1;
                }
                return this.typeCoercionEnabled;
            }

            void withTypeCoercionEnabled(boolean typeCoercionEnabled) {
                this.typeCoercionEnabled = typeCoercionEnabled;
                this.typeCoercionEnabledBuildStage = 1;
            }

            SqlConformance conformance() {
                if (this.conformanceBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.conformanceBuildStage == 0) {
                    this.conformanceBuildStage = (byte)-1;
                    this.conformance = Objects.requireNonNull(Config.this.conformanceInitialize(), "conformance");
                    this.conformanceBuildStage = 1;
                }
                return this.conformance;
            }

            void withConformance(SqlConformance conformance) {
                this.conformance = conformance;
                this.conformanceBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.callRewriteBuildStage == -1) {
                    attributes.add("callRewrite");
                }
                if (this.defaultNullCollationBuildStage == -1) {
                    attributes.add("defaultNullCollation");
                }
                if (this.columnReferenceExpansionBuildStage == -1) {
                    attributes.add("columnReferenceExpansion");
                }
                if (this.identifierExpansionBuildStage == -1) {
                    attributes.add("identifierExpansion");
                }
                if (this.embeddedQueryBuildStage == -1) {
                    attributes.add("embeddedQuery");
                }
                if (this.lenientOperatorLookupBuildStage == -1) {
                    attributes.add("lenientOperatorLookup");
                }
                if (this.nakedMeasuresInNonAggregateQueryBuildStage == -1) {
                    attributes.add("nakedMeasuresInNonAggregateQuery");
                }
                if (this.nakedMeasuresInAggregateQueryBuildStage == -1) {
                    attributes.add("nakedMeasuresInAggregateQuery");
                }
                if (this.typeCoercionEnabledBuildStage == -1) {
                    attributes.add("typeCoercionEnabled");
                }
                if (this.conformanceBuildStage == -1) {
                    attributes.add("conformance");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

