/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data.type;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandler;
import org.jkiss.utils.CommonUtils;

public class PostgreStringTypeHandler
extends PostgreTypeHandler {
    public static final PostgreStringTypeHandler INSTANCE = new PostgreStringTypeHandler();

    private PostgreStringTypeHandler() {
    }

    @Override
    public int getTypeModifiers(@NotNull PostgreDataType type, @NotNull String typeName, @NotNull String[] typmod) throws DBException {
        switch (typmod.length) {
            case 0: {
                return -1;
            }
            case 1: {
                return PostgreStringTypeHandler.getStringModifiers(type, CommonUtils.toInt((Object)typmod[0]));
            }
        }
        return super.getTypeModifiers(type, typeName, typmod);
    }

    @Override
    @NotNull
    public String getTypeModifiersString(@NotNull PostgreDataType type, int typmod) {
        Integer length;
        StringBuilder sb = new StringBuilder();
        if (typmod > 0 && (length = this.getTypeLength(type, typmod)) != null) {
            sb.append('(').append(length).append(')');
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public Integer getTypeLength(@NotNull PostgreDataType type, int typmod) {
        if (typmod < 0) {
            return null;
        }
        switch ((int)type.getObjectId()) {
            case 1560: 
            case 1562: {
                return typmod;
            }
        }
        return typmod - 4;
    }

    private static int getStringModifiers(@NotNull PostgreDataType type, int length) throws DBException {
        if (length < 0) {
            throw new DBException("Length for type '" + type.getName() + "' must be at least 1");
        }
        switch ((int)type.getObjectId()) {
            case 1560: 
            case 1562: {
                return length;
            }
        }
        return length + 4;
    }
}

