/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSVisibilityScopeProvider;

public class SQLQueryConnectionRealContext
extends SQLQueryConnectionContext {
    private static final Log log = Log.getLog(SQLQueryConnectionRealContext.class);
    private final boolean validateFunctions;
    @NotNull
    private final SQLIdentifierDetector identifierDetector;
    @NotNull
    private final DBCExecutionContext executionContext;
    @NotNull
    private final Map<String, SQLQueryResultPseudoColumn> globalPseudoColumnsByCanonicalName;
    @NotNull
    private final Function<SQLQueryRowsSourceModel, List<SQLQueryResultPseudoColumn>> rowsetPseudoColumnsProvider;

    public SQLQueryConnectionRealContext(@NotNull SQLDialect dialect, @NotNull SQLIdentifierDetector identifierDetector, @NotNull DBCExecutionContext executionContext, boolean validateFunctions, @NotNull Map<String, SQLQueryResultPseudoColumn> globalPseudoColumns, @NotNull Function<SQLQueryRowsSourceModel, List<SQLQueryResultPseudoColumn>> rowsetPseudoColumnsProvider) {
        super(dialect);
        this.validateFunctions = validateFunctions;
        this.identifierDetector = identifierDetector;
        this.executionContext = executionContext;
        this.globalPseudoColumnsByCanonicalName = globalPseudoColumns;
        this.rowsetPseudoColumnsProvider = rowsetPseudoColumnsProvider;
    }

    @Override
    @NotNull
    public List<SQLQueryResultPseudoColumn> obtainRowsetPseudoColumns(@Nullable SQLQueryRowsSourceModel rowsSource) {
        return this.rowsetPseudoColumnsProvider.apply(rowsSource);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    @NotNull
    protected List<? extends DBSObject> findRealObjectsImpl(@NotNull DBRProgressMonitor monitor, @NotNull List<String> objectName) {
        DBPDataSource dBPDataSource = this.executionContext.getDataSource();
        if (dBPDataSource instanceof DBSObjectContainer) {
            DBSObjectContainer container = (DBSObjectContainer)dBPDataSource;
            List<? extends DBSObject> objs = SQLSearchUtils.findObjectsByFQN(monitor, container, this.executionContext, objectName, false, this.identifierDetector, this.validateFunctions);
            if (objs.isEmpty()) {
                DBSVisibilityScopeProvider contextScope;
                DBPDataSource dBPDataSource2;
                DBSVisibilityScopeProvider scopeProvider;
                DBSVisibilityScopeProvider currentScope;
                DBSObject dBSObject = DBUtils.getSelectedObject((DBCExecutionContext)this.executionContext);
                Object object = dBSObject instanceof DBSVisibilityScopeProvider ? (currentScope = (DBSVisibilityScopeProvider)dBSObject) : (scopeProvider = (dBPDataSource2 = this.executionContext.getDataSource()) instanceof DBSVisibilityScopeProvider ? (contextScope = (DBSVisibilityScopeProvider)dBPDataSource2) : null);
                if (scopeProvider != null) {
                    try {
                        for (DBSObjectContainer scope : scopeProvider.getPublicScopes(monitor)) {
                            objs = SQLSearchUtils.findObjectsByFQN(monitor, scope, this.executionContext, objectName, false, this.identifierDetector, this.validateFunctions);
                            if (objs.isEmpty()) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (DBException e) {
                        String name = String.join((CharSequence)Character.toString(this.executionContext.getDataSource().getSQLDialect().getStructSeparator()), objectName);
                        log.error((Object)("Failed to resolve real database object " + name), (Throwable)e);
                    }
                }
            }
            return objs;
        }
        throw new UnsupportedOperationException("Semantic analyser should never be used for databases, which doesn't support table lookup");
    }

    @Override
    @Nullable
    public SQLQueryResultPseudoColumn resolveGlobalPseudoColumn(@NotNull String name) {
        return this.globalPseudoColumnsByCanonicalName.get(name);
    }
}

