/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.actions;

import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.actions.AbstractResultSetViewerAction;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;

public class TransformComplexTypesToggleAction
extends AbstractResultSetViewerAction {
    public TransformComplexTypesToggleAction(ResultSetViewer resultSetViewer) {
        super(resultSetViewer, ResultSetMessages.actions_name_structurize_complex_types, 2);
        this.setToolTipText("Visualize complex types (arrays, structures, maps) in results grid as separate columns");
    }

    public boolean isChecked() {
        DBPDataSource dataSource = this.getResultSetViewer().getDataContainer().getDataSource();
        return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type");
    }

    public void run() {
        DBPPreferenceStore preferenceStore;
        DBPDataSource dataSource = this.getResultSetViewer().getDataContainer().getDataSource();
        if (dataSource == null) {
            return;
        }
        boolean curValue = (preferenceStore = dataSource.getContainer().getPreferenceStore()).getBoolean("resultset.transform.complex.type");
        preferenceStore.setValue("resultset.transform.complex.type", !curValue);
        dataSource.getContainer().persistConfiguration();
        this.getResultSetViewer().refreshData(null);
    }
}

