/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gbase8s.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class GBase8sTableTrigger
extends GenericTableTrigger {
    private TriggerEventType eventType;
    private final String collation;

    public GBase8sTableTrigger(@NotNull GenericTableBase container, String name, @NotNull JDBCResultSet resultSet) {
        super(container, name, null);
        String eventTypeLetter = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"event");
        if (CommonUtils.isNotEmpty((String)eventTypeLetter)) {
            this.eventType = (TriggerEventType)CommonUtils.valueOf(TriggerEventType.class, (String)eventTypeLetter);
        }
        this.collation = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"collation");
    }

    @Property(viewable=true, order=5)
    public String getEventType() {
        return this.eventType.getEventType();
    }

    @Property(viewable=true, order=6)
    public String getCollation() {
        return this.collation;
    }

    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public static enum TriggerEventType {
        D("DELETE"),
        I("INSERT"),
        U("UPDATE"),
        S("SELECT"),
        d("INSTEAD OF Delete"),
        i("INSTEAD OF Insert"),
        u("INSTEAD OF Update");

        private final String eventType;

        private TriggerEventType(String eventType) {
            this.eventType = eventType;
        }

        public String getEventType() {
            return this.eventType;
        }
    }
}

