/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.caching.impl;

import com.google.common.collect.ImmutableList;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.SimpleBuildCacheKey;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.caching.CachingStateFactory;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.slf4j.Logger;

public class DefaultCachingStateFactory
implements CachingStateFactory {
    private final Logger logger;

    public DefaultCachingStateFactory(Logger logger) {
        this.logger = logger;
    }

    @Override
    public final CachingState createCachingState(BeforeExecutionState beforeExecutionState, HashCode cacheKey, ImmutableList<CachingDisabledReason> cachingDisabledReasons) {
        if (cachingDisabledReasons.isEmpty()) {
            return CachingState.enabled((BuildCacheKey)new SimpleBuildCacheKey(cacheKey), beforeExecutionState);
        }
        cachingDisabledReasons.forEach(reason -> this.logger.warn("Non-cacheable because {} [{}]", (Object)reason.getMessage(), (Object)reason.getCategory()));
        return CachingState.disabled(cachingDisabledReasons, (BuildCacheKey)new SimpleBuildCacheKey(cacheKey), beforeExecutionState);
    }

    @Override
    public HashCode calculateCacheKey(BeforeExecutionState beforeExecutionState) {
        Hasher cacheKeyHasher = Hashing.newHasher();
        this.logger.warn("Appending implementation to build cache key: {}", (Object)beforeExecutionState.getImplementation());
        beforeExecutionState.getImplementation().appendToHasher(cacheKeyHasher);
        beforeExecutionState.getAdditionalImplementations().forEach(additionalImplementation -> {
            this.logger.warn("Appending additional implementation to build cache key: {}", additionalImplementation);
            additionalImplementation.appendToHasher(cacheKeyHasher);
        });
        beforeExecutionState.getInputProperties().forEach((propertyName, valueSnapshot) -> {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Appending input value fingerprint for '{}' to build cache key: {}", propertyName, (Object)Hashing.hashHashable((Hashable)valueSnapshot));
            }
            cacheKeyHasher.putString((CharSequence)propertyName);
            valueSnapshot.appendToHasher(cacheKeyHasher);
        });
        beforeExecutionState.getInputFileProperties().forEach((propertyName, fingerprint) -> {
            this.logger.warn("Appending input file fingerprints for '{}' to build cache key: {} - {}", new Object[]{propertyName, fingerprint.getHash(), fingerprint});
            cacheKeyHasher.putString((CharSequence)propertyName);
            cacheKeyHasher.putHash(fingerprint.getHash());
        });
        beforeExecutionState.getOutputFileLocationSnapshots().keySet().forEach(propertyName -> {
            this.logger.warn("Appending output property name to build cache key: {}", propertyName);
            cacheKeyHasher.putString((CharSequence)propertyName);
        });
        return cacheKeyHasher.hash();
    }
}

