﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-signals/ApplicationSignals_EXPORTS.h>
#include <aws/application-signals/model/ServiceDependent.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ApplicationSignals {
namespace Model {
class ListServiceDependentsResult {
 public:
  AWS_APPLICATIONSIGNALS_API ListServiceDependentsResult() = default;
  AWS_APPLICATIONSIGNALS_API ListServiceDependentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPLICATIONSIGNALS_API ListServiceDependentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The start of the time period that the returned information applies to. When
   * used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For
   * example: <code>1698778057</code> </p> <p>This displays the time that Application
   * Signals used for the request. It might not match your request exactly, because
   * it was rounded to the nearest hour.</p>
   */
  inline const Aws::Utils::DateTime& GetStartTime() const { return m_startTime; }
  template <typename StartTimeT = Aws::Utils::DateTime>
  void SetStartTime(StartTimeT&& value) {
    m_startTimeHasBeenSet = true;
    m_startTime = std::forward<StartTimeT>(value);
  }
  template <typename StartTimeT = Aws::Utils::DateTime>
  ListServiceDependentsResult& WithStartTime(StartTimeT&& value) {
    SetStartTime(std::forward<StartTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The end of the time period that the returned information applies to. When
   * used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For
   * example: <code>1698778057</code> </p> <p>This displays the time that Application
   * Signals used for the request. It might not match your request exactly, because
   * it was rounded to the nearest hour.</p>
   */
  inline const Aws::Utils::DateTime& GetEndTime() const { return m_endTime; }
  template <typename EndTimeT = Aws::Utils::DateTime>
  void SetEndTime(EndTimeT&& value) {
    m_endTimeHasBeenSet = true;
    m_endTime = std::forward<EndTimeT>(value);
  }
  template <typename EndTimeT = Aws::Utils::DateTime>
  ListServiceDependentsResult& WithEndTime(EndTimeT&& value) {
    SetEndTime(std::forward<EndTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array, where each object in the array contains information about one of
   * the dependents of this service.</p>
   */
  inline const Aws::Vector<ServiceDependent>& GetServiceDependents() const { return m_serviceDependents; }
  template <typename ServiceDependentsT = Aws::Vector<ServiceDependent>>
  void SetServiceDependents(ServiceDependentsT&& value) {
    m_serviceDependentsHasBeenSet = true;
    m_serviceDependents = std::forward<ServiceDependentsT>(value);
  }
  template <typename ServiceDependentsT = Aws::Vector<ServiceDependent>>
  ListServiceDependentsResult& WithServiceDependents(ServiceDependentsT&& value) {
    SetServiceDependents(std::forward<ServiceDependentsT>(value));
    return *this;
  }
  template <typename ServiceDependentsT = ServiceDependent>
  ListServiceDependentsResult& AddServiceDependents(ServiceDependentsT&& value) {
    m_serviceDependentsHasBeenSet = true;
    m_serviceDependents.emplace_back(std::forward<ServiceDependentsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Include this value in your next use of this API to get next set of service
   * dependents.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListServiceDependentsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListServiceDependentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_startTime{};

  Aws::Utils::DateTime m_endTime{};

  Aws::Vector<ServiceDependent> m_serviceDependents;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_startTimeHasBeenSet = false;
  bool m_endTimeHasBeenSet = false;
  bool m_serviceDependentsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationSignals
}  // namespace Aws
