﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/Mapping.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>Specifies a transform that maps data property keys in the data source to data
 * property keys in the data target. You can rename keys, modify the data types for
 * keys, and choose which keys to drop from the dataset.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ApplyMapping">AWS
 * API Reference</a></p>
 */
class ApplyMapping {
 public:
  AWS_GLUE_API ApplyMapping() = default;
  AWS_GLUE_API ApplyMapping(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API ApplyMapping& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the transform node.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ApplyMapping& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data inputs identified by their node names.</p>
   */
  inline const Aws::Vector<Aws::String>& GetInputs() const { return m_inputs; }
  inline bool InputsHasBeenSet() const { return m_inputsHasBeenSet; }
  template <typename InputsT = Aws::Vector<Aws::String>>
  void SetInputs(InputsT&& value) {
    m_inputsHasBeenSet = true;
    m_inputs = std::forward<InputsT>(value);
  }
  template <typename InputsT = Aws::Vector<Aws::String>>
  ApplyMapping& WithInputs(InputsT&& value) {
    SetInputs(std::forward<InputsT>(value));
    return *this;
  }
  template <typename InputsT = Aws::String>
  ApplyMapping& AddInputs(InputsT&& value) {
    m_inputsHasBeenSet = true;
    m_inputs.emplace_back(std::forward<InputsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the mapping of data property keys in the data source to data
   * property keys in the data target.</p>
   */
  inline const Aws::Vector<Mapping>& GetMapping() const { return m_mapping; }
  inline bool MappingHasBeenSet() const { return m_mappingHasBeenSet; }
  template <typename MappingT = Aws::Vector<Mapping>>
  void SetMapping(MappingT&& value) {
    m_mappingHasBeenSet = true;
    m_mapping = std::forward<MappingT>(value);
  }
  template <typename MappingT = Aws::Vector<Mapping>>
  ApplyMapping& WithMapping(MappingT&& value) {
    SetMapping(std::forward<MappingT>(value));
    return *this;
  }
  template <typename MappingT = Mapping>
  ApplyMapping& AddMapping(MappingT&& value) {
    m_mappingHasBeenSet = true;
    m_mapping.emplace_back(std::forward<MappingT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::Vector<Aws::String> m_inputs;

  Aws::Vector<Mapping> m_mapping;
  bool m_nameHasBeenSet = false;
  bool m_inputsHasBeenSet = false;
  bool m_mappingHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
