﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mq/MQ_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MQ {
namespace Model {
class CreateBrokerResult {
 public:
  AWS_MQ_API CreateBrokerResult() = default;
  AWS_MQ_API CreateBrokerResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MQ_API CreateBrokerResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The broker's Amazon Resource Name (ARN).</p>
   */
  inline const Aws::String& GetBrokerArn() const { return m_brokerArn; }
  template <typename BrokerArnT = Aws::String>
  void SetBrokerArn(BrokerArnT&& value) {
    m_brokerArnHasBeenSet = true;
    m_brokerArn = std::forward<BrokerArnT>(value);
  }
  template <typename BrokerArnT = Aws::String>
  CreateBrokerResult& WithBrokerArn(BrokerArnT&& value) {
    SetBrokerArn(std::forward<BrokerArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID that Amazon MQ generates for the broker.</p>
   */
  inline const Aws::String& GetBrokerId() const { return m_brokerId; }
  template <typename BrokerIdT = Aws::String>
  void SetBrokerId(BrokerIdT&& value) {
    m_brokerIdHasBeenSet = true;
    m_brokerId = std::forward<BrokerIdT>(value);
  }
  template <typename BrokerIdT = Aws::String>
  CreateBrokerResult& WithBrokerId(BrokerIdT&& value) {
    SetBrokerId(std::forward<BrokerIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateBrokerResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_brokerArn;

  Aws::String m_brokerId;

  Aws::String m_requestId;
  bool m_brokerArnHasBeenSet = false;
  bool m_brokerIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MQ
}  // namespace Aws
