/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.AbstractRubyMethod;
import org.jruby.IncludedModuleWrapper;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Define;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.PartialDelegatingMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

@JRubyClass(name={"UnboundMethod"}, parent="Method")
public class RubyUnboundMethod
extends AbstractRubyMethod {
    protected RubyUnboundMethod(Ruby runtime2) {
        super(runtime2, runtime2.getUnboundMethod());
    }

    public static RubyUnboundMethod newUnboundMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, CacheEntry entry) {
        RubyUnboundMethod newMethod = new RubyUnboundMethod(implementationModule.getRuntime());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.entry = entry;
        newMethod.method = entry.method;
        newMethod.sourceModule = entry.sourceModule;
        return newMethod;
    }

    public static RubyClass defineUnboundMethodClass(ThreadContext context, RubyClass Object2) {
        return ((RubyModule)((RubyModule)Define.defineClass(context, "UnboundMethod", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).reifiedClass(RubyUnboundMethod.class)).classIndex(ClassIndex.UNBOUNDMETHOD)).defineMethods(context, AbstractRubyMethod.class, RubyUnboundMethod.class).tap(c -> c.singletonClass(context).undefMethods(context, "new"));
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        return Convert.asBoolean(context, this.equals(other));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AbstractRubyMethod)) {
            return false;
        }
        if (this.method instanceof ProcMethod) {
            return ((ProcMethod)this.method).isSame(((AbstractRubyMethod)other).getMethod());
        }
        AbstractRubyMethod otherMethod = (AbstractRubyMethod)other;
        return this.method.getRealMethod().getSerialNumber() == otherMethod.method.getRealMethod().getSerialNumber();
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashCode());
    }

    @Override
    public int hashCode() {
        long serial = this.method.getRealMethod().getSerialNumber();
        return 997 * ((int)(serial >> 32) ^ (int)serial & 0xFF);
    }

    @JRubyMethod
    public RubyMethod bind(ThreadContext context, IRubyObject aReceiver) {
        RubyClass receiverClass = aReceiver.getMetaClass();
        receiverClass.checkValidBindTargetFrom(context, (RubyModule)this.owner(context), true);
        CacheEntry methodEntry = this.convertUnboundMethodToCallableEntry(context, receiverClass);
        return RubyMethod.newMethod(this.implementationModule, this.methodName, receiverClass, this.originName, methodEntry, aReceiver);
    }

    private CacheEntry convertUnboundMethodToCallableEntry(ThreadContext context, RubyClass receiverClass) {
        CacheEntry methodEntry = this.entry;
        if (this.implementationModule.isModule()) {
            IncludedModuleWrapper alreadyIncluded = receiverClass.findModuleInAncestors(this.implementationModule);
            if (alreadyIncluded != null) {
                methodEntry = new CacheEntry(this.method, alreadyIncluded, this.entry.token);
            } else {
                IncludedModuleWrapper boundModule = new IncludedModuleWrapper(context.runtime, receiverClass, this.implementationModule);
                methodEntry = new CacheEntry(this.method, boundModule, this.entry.token);
            }
        }
        return methodEntry;
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyUnboundMethod rbClone() {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry);
        ThreadContext context = this.getRuntime().getCurrentContext();
        return (RubyUnboundMethod)this.cloneSetup(context, unboundMethod, context.nil);
    }

    @Override
    @JRubyMethod
    public RubyUnboundMethod dup(ThreadContext context) {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry);
        return (RubyUnboundMethod)this.dupSetup(context, unboundMethod);
    }

    @JRubyMethod(required=1, rest=true, checkArity=false, keywords=true)
    public IRubyObject bind_call(ThreadContext context, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        IRubyObject receiver2 = args2[0];
        IRubyObject[] newArgs = new IRubyObject[argc - 1];
        System.arraycopy(args2, 1, newArgs, 0, argc - 1);
        RubyClass receiverClass = receiver2.getMetaClass();
        receiverClass.checkValidBindTargetFrom(context, (RubyModule)this.owner(context), true);
        CacheEntry methodEntry = this.convertUnboundMethodToCallableEntry(context, receiverClass);
        return this.method.call(context, receiver2, methodEntry.sourceModule, this.methodName, newArgs, block);
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect(ThreadContext context) {
        return this.inspect((IRubyObject)null);
    }

    @JRubyMethod
    public IRubyObject super_method(ThreadContext context) {
        RubyClass superClass = null;
        if (this.method instanceof PartialDelegatingMethod || this.method instanceof AliasMethod) {
            RubyModule definedClass = this.method.getRealMethod().getDefinedClass();
            RubyModule module = this.sourceModule.findImplementer(definedClass);
            if (module != null) {
                superClass = module.getSuperClass();
            }
        } else {
            superClass = this.sourceModule.getSuperClass();
        }
        return this.super_method(context, null, superClass);
    }
}

