/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Screen;
import com.tigervnc.rfb.ScreenSet;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.OptionsDialog;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.Viewport;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ListIterator;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class DesktopWindow
extends JFrame {
    static LogWriter vlog = new LogWriter("DesktopWindow");
    private CConn cc;
    private JScrollPane scroll;
    public Viewport viewport;
    private boolean firstUpdate;
    private boolean delayedFullscreen;
    private boolean delayedDesktopSize;
    private boolean canDoLionFS;
    private String lastScaleFactor;
    private Rectangle lastBounds;
    private int lastState;
    private Timer timer;

    public DesktopWindow(int n, int n2, String string, PixelFormat pixelFormat, CConn cConn) {
        this.cc = cConn;
        this.firstUpdate = true;
        this.delayedFullscreen = false;
        this.delayedDesktopSize = false;
        this.setFocusable(false);
        this.setFocusTraversalKeysEnabled(false);
        this.getToolkit().setDynamicLayout(false);
        if (!VncViewer.os.startsWith("mac os x")) {
            this.setIconImage(VncViewer.frameIcon);
        }
        UIManager.getDefaults().put("ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[0]));
        this.scroll = new JScrollPane(new Viewport(n, n2, pixelFormat, this.cc));
        this.viewport = (Viewport)this.scroll.getViewport().getView();
        this.scroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.scroll);
        this.setName(string);
        this.lastScaleFactor = Parameters.scalingFactor.getValue();
        if (VncViewer.os.startsWith("mac os x") && !Parameters.noLionFS.getValue()) {
            this.enableLionFS();
        }
        OptionsDialog.addCallback("handleOptions", this);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                if (DesktopWindow.this.isVisible() && DesktopWindow.this.scroll.getViewport() != null) {
                    DesktopWindow.this.scroll.getViewport().getView().requestFocusInWindow();
                }
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                DesktopWindow.this.viewport.releaseDownKeys();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DesktopWindow.this.cc.close();
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                DesktopWindow.this.repositionViewport();
            }
        });
        this.addWindowStateListener(new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
                Rectangle rectangle;
                int n = windowEvent.getNewState();
                if ((n & 6) != 6 && !(rectangle = DesktopWindow.this.getGraphicsConfiguration().getBounds()).contains(DesktopWindow.this.getLocationOnScreen())) {
                    DesktopWindow.this.setLocation((int)rectangle.getX(), (int)rectangle.getY());
                }
                DesktopWindow.this.repositionViewport();
            }
        });
        this.timer = new Timer(500, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesktopWindow.this.handleResizeTimeout();
            }
        });
        this.timer.setRepeats(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (Parameters.remoteResize.getValue()) {
                    if (DesktopWindow.this.timer.isRunning()) {
                        DesktopWindow.this.timer.restart();
                    } else if (!DesktopWindow.this.firstUpdate && !DesktopWindow.this.delayedFullscreen && Parameters.remoteResize.getValue() && ((DesktopWindow)DesktopWindow.this).cc.server.supportsSetDesktopSize) {
                        DesktopWindow.this.timer.start();
                    }
                } else {
                    String string = Parameters.scalingFactor.getValue();
                    if (!string.matches("^[0-9]+$")) {
                        Dimension dimension = DesktopWindow.this.getContentPane().getSize();
                        if (dimension.width != DesktopWindow.this.viewport.scaledWidth || dimension.height != DesktopWindow.this.viewport.scaledHeight) {
                            DesktopWindow.this.viewport.setScaledSize(dimension.width, dimension.height);
                        }
                        if (!(string.equals("Auto") || DesktopWindow.this.isMaximized() || DesktopWindow.this.fullscreen_active())) {
                            int n = DesktopWindow.this.getInsets().left + DesktopWindow.this.getInsets().right;
                            int n2 = DesktopWindow.this.getInsets().top + DesktopWindow.this.getInsets().bottom;
                            DesktopWindow.this.setSize(DesktopWindow.this.viewport.scaledWidth + n, DesktopWindow.this.viewport.scaledHeight + n2);
                        }
                    }
                    DesktopWindow.this.repositionViewport();
                }
            }
        });
    }

    @Override
    public void setSize(Dimension dimension) {
        ComponentListener[] componentListenerArray;
        for (ComponentListener componentListener : componentListenerArray = (ComponentListener[])this.getListeners(ComponentListener.class)) {
            this.removeComponentListener(componentListener);
        }
        super.setSize(dimension);
        for (ComponentListener componentListener : componentListenerArray) {
            this.addComponentListener(componentListener);
        }
    }

    @Override
    public void setSize(int n, int n2) {
        ComponentListener[] componentListenerArray;
        for (ComponentListener componentListener : componentListenerArray = (ComponentListener[])this.getListeners(ComponentListener.class)) {
            this.removeComponentListener(componentListener);
        }
        super.setSize(n, n2);
        for (ComponentListener componentListener : componentListenerArray) {
            this.addComponentListener(componentListener);
        }
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        ComponentListener[] componentListenerArray;
        for (ComponentListener componentListener : componentListenerArray = (ComponentListener[])this.getListeners(ComponentListener.class)) {
            this.removeComponentListener(componentListener);
        }
        super.setBounds(rectangle);
        for (ComponentListener componentListener : componentListenerArray) {
            this.addComponentListener(componentListener);
        }
    }

    private void repositionViewport() {
        this.scroll.revalidate();
        Rectangle rectangle = this.scroll.getViewportBorderBounds();
        int n = rectangle.width - this.viewport.scaledWidth;
        int n2 = rectangle.height - this.viewport.scaledHeight;
        int n3 = (int)Math.max(Math.floor(n2 / 2), 0.0);
        int n4 = (int)Math.max(Math.floor(n / 2), 0.0);
        int n5 = Math.max(n2 - n3, 0);
        int n6 = Math.max(n - n4, 0);
        Insets insets = new Insets(n3, n4, n5, n6);
        this.scroll.setViewportBorder(new MatteBorder(insets, Color.BLACK));
        this.scroll.revalidate();
    }

    public PixelFormat getPreferredPF() {
        return this.viewport.getPreferredPF();
    }

    @Override
    public void setName(String string) {
        this.setTitle(string);
    }

    public void updateWindow() {
        if (this.firstUpdate) {
            this.pack();
            if (Parameters.fullScreen.getValue()) {
                this.fullscreen_on();
            } else {
                this.setVisible(true);
            }
            if (Parameters.maximize.getValue()) {
                this.setExtendedState(6);
            }
            if (this.cc.server.supportsSetDesktopSize && !Parameters.desktopSize.getValue().equals("")) {
                if (this.delayedFullscreen) {
                    this.delayedDesktopSize = true;
                } else {
                    this.handleDesktopSize();
                }
            }
            this.firstUpdate = false;
        }
        this.viewport.updateWindow();
    }

    public void resizeFramebuffer(int n, int n2) {
        if (n == this.viewport.scaledWidth && n2 == this.viewport.scaledHeight) {
            return;
        }
        int n3 = this.getInsets().left + this.getInsets().right;
        int n4 = this.getInsets().top + this.getInsets().bottom;
        if (!this.fullscreen_active()) {
            if (this.w() == this.viewport.scaledWidth && this.h() == this.viewport.scaledHeight) {
                this.setSize(n + n3, n2 + n4);
            } else if (this.w() > n || this.h() > n2) {
                this.setSize(Math.min(this.w(), n) + n3, Math.min(this.h(), n2) + n4);
            }
        }
        this.viewport.resize(0, 0, n, n2);
        this.repositionViewport();
        this.validate();
    }

    public void setCursor(int n, int n2, Point point, byte[] byArray) {
        this.viewport.setCursor(n, n2, point, byArray);
    }

    public void fullscreen_on() {
        Parameters.fullScreen.setParam(true);
        this.lastState = this.getExtendedState();
        this.lastBounds = this.getBounds();
        this.dispose();
        this.setExtendedState(0);
        this.setUndecorated(true);
        this.setVisible(true);
        this.setBounds(this.getScreenBounds());
    }

    public void fullscreen_off() {
        Parameters.fullScreen.setParam(false);
        this.dispose();
        this.setUndecorated(false);
        this.setExtendedState(this.lastState);
        this.setBounds(this.lastBounds);
        this.setVisible(true);
    }

    public boolean fullscreen_active() {
        return this.isUndecorated();
    }

    private void handleDesktopSize() {
        if (!Parameters.desktopSize.getValue().equals("")) {
            if (Parameters.desktopSize.getValue().split("x").length != 2) {
                return;
            }
            int n = Integer.parseInt(Parameters.desktopSize.getValue().split("x")[0]);
            int n2 = Integer.parseInt(Parameters.desktopSize.getValue().split("x")[1]);
            this.remoteResize(n, n2);
        } else if (Parameters.remoteResize.getValue()) {
            this.remoteResize(this.w(), this.h());
        }
    }

    public void handleResizeTimeout() {
        DesktopWindow desktopWindow = this;
        assert (desktopWindow != null);
        desktopWindow.remoteResize(desktopWindow.w(), desktopWindow.h());
    }

    private void remoteResize(int n, int n2) {
        ScreenSet screenSet;
        if (!this.fullscreen_active() || n > this.w() || n2 > this.h()) {
            screenSet = this.cc.server.screenLayout();
            if (screenSet.num_screens() == 0) {
                screenSet.add_screen(new Screen());
            } else if (screenSet.num_screens() != 1) {
                while (true) {
                    ListIterator<Screen> listIterator = screenSet.begin();
                    Screen screen = listIterator.next();
                    if (listIterator == screenSet.end()) break;
                    screenSet.remove_screen(screen.id);
                }
            }
            screenSet.begin().next().dimensions.tl.x = 0;
            screenSet.begin().next().dimensions.tl.y = 0;
            screenSet.begin().next().dimensions.br.x = n;
            screenSet.begin().next().dimensions.br.y = n2;
        } else {
            screenSet = new ScreenSet();
            Rect rect = new Rect();
            Rect rect2 = new Rect();
            rect.setXYWH(this.x() + (this.w() - n) / 2, this.y() + (this.h() - n2) / 2, n, n2);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
                for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                    int n3;
                    Object object;
                    Rectangle rectangle = graphicsConfiguration.getBounds();
                    int n4 = rectangle.x;
                    int n5 = rectangle.y;
                    int n6 = rectangle.width;
                    int n7 = rectangle.height;
                    rect2.setXYWH(n4, n5, n6, n7);
                    if (!rect2.enclosed_by(rect)) continue;
                    n4 -= rect.tl.x;
                    n5 -= rect.tl.y;
                    ListIterator<Screen> listIterator = this.cc.server.screenLayout().begin();
                    while (listIterator != this.cc.server.screenLayout().end()) {
                        object = listIterator.next();
                        listIterator.previous();
                        if (((Screen)object).dimensions.tl.x == n4 && ((Screen)object).dimensions.tl.y == n5 && ((Screen)object).dimensions.width() == n6 && ((Screen)object).dimensions.height() == n7) break;
                        listIterator.next();
                    }
                    if (listIterator != this.cc.server.screenLayout().end()) {
                        screenSet.add_screen(listIterator.next());
                        continue;
                    }
                    object = new Random();
                    block4: do {
                        n3 = ((Random)object).nextInt();
                        listIterator = this.cc.server.screenLayout().begin();
                        while (listIterator != this.cc.server.screenLayout().end()) {
                            Screen screen = listIterator.next();
                            listIterator.previous();
                            if (screen.id == n3) continue block4;
                            listIterator.next();
                        }
                    } while (listIterator != this.cc.server.screenLayout().end());
                    screenSet.add_screen(new Screen(n3, n4, n5, n6, n7, 0));
                }
                if (screenSet.num_screens() != 0) continue;
                screenSet.add_screen(new Screen(0, 0, 0, n, n2, 0));
            }
        }
        if (n == this.cc.server.width() && n2 == this.cc.server.height() && screenSet == this.cc.server.screenLayout()) {
            return;
        }
        vlog.debug(String.format("Requesting framebuffer resize from %dx%d to %dx%d", this.cc.server.width(), this.cc.server.height(), n, n2), new Object[0]);
        screenSet.debug_print();
        if (!screenSet.validate(n, n2)) {
            vlog.error("Invalid screen layout computed for resize request!", new Object[0]);
            return;
        }
        this.cc.writer().writeSetDesktopSize(n, n2, screenSet);
    }

    boolean lionFSSupported() {
        return this.canDoLionFS;
    }

    private int x() {
        return this.getContentPane().getX();
    }

    private int y() {
        return this.getContentPane().getY();
    }

    private int w() {
        return this.getContentPane().getWidth();
    }

    private int h() {
        return this.getContentPane().getHeight();
    }

    void enableLionFS() {
        try {
            double d;
            String string = System.getProperty("os.version");
            int n = string.indexOf(46);
            int n2 = string.lastIndexOf(46);
            if (n2 > n && n2 >= 0) {
                string = string.substring(0, string.indexOf(46, n + 1));
            }
            if ((d = Double.parseDouble(string)) < 10.7) {
                throw new Exception("Operating system version is " + d);
            }
            Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
            Class[] classArray = new Class[]{Window.class, Boolean.TYPE};
            Method method = clazz.getMethod("setWindowCanFullScreen", classArray);
            method.invoke(clazz, this, true);
            this.canDoLionFS = true;
        }
        catch (Exception exception) {
            vlog.debug("Could not enable OS X 10.7+ full-screen mode: " + exception.getMessage(), new Object[0]);
        }
    }

    public void toggleLionFS() {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Method method = clazz.getMethod("getApplication", null);
            Object object = method.invoke(clazz, new Object[0]);
            Method method2 = clazz.getMethod("requestToggleFullScreen", Window.class);
            method2.invoke(object, this);
        }
        catch (Exception exception) {
            vlog.debug("Could not toggle OS X 10.7+ full-screen mode: " + exception.getMessage(), new Object[0]);
        }
    }

    public boolean isMaximized() {
        int n = this.getExtendedState();
        return (n & 6) == 6;
    }

    public Dimension getScreenSize() {
        return this.getScreenBounds().getSize();
    }

    public Rectangle getScreenBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = new Rectangle();
        if (Parameters.fullScreenAllMonitors.getValue()) {
            for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
                for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                    rectangle = rectangle.union(graphicsConfiguration.getBounds());
                }
            }
        } else {
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            rectangle = graphicsConfiguration.getBounds();
        }
        return rectangle;
    }

    public static Window getFullScreenWindow() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
            Window window = graphicsDevice.getFullScreenWindow();
            if (window == null) continue;
            return window;
        }
        return null;
    }

    public static void setFullScreenWindow(Window window) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (Parameters.fullScreenAllMonitors.getValue()) {
            for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
                graphicsDevice.setFullScreenWindow(window);
            }
        } else {
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            graphicsDevice.setFullScreenWindow(window);
        }
    }

    public void handleOptions() {
        if (Parameters.fullScreen.getValue() && !this.fullscreen_active()) {
            this.fullscreen_on();
        } else if (!Parameters.fullScreen.getValue() && this.fullscreen_active()) {
            this.fullscreen_off();
        }
        if (Parameters.remoteResize.getValue()) {
            this.scroll.setHorizontalScrollBarPolicy(30);
            this.scroll.setVerticalScrollBarPolicy(20);
            this.remoteResize(this.w(), this.h());
        } else {
            String string = Parameters.scalingFactor.getValue();
            if (!string.equals(this.lastScaleFactor)) {
                if (string.matches("^[0-9]+$")) {
                    this.scroll.setHorizontalScrollBarPolicy(30);
                    this.scroll.setVerticalScrollBarPolicy(20);
                    this.viewport.setScaledSize(this.cc.server.width(), this.cc.server.height());
                } else {
                    this.scroll.setHorizontalScrollBarPolicy(31);
                    this.scroll.setVerticalScrollBarPolicy(21);
                    this.viewport.setScaledSize(this.w(), this.h());
                }
                if (this.isMaximized() || this.fullscreen_active()) {
                    this.repositionViewport();
                } else {
                    int n = this.getInsets().left + this.getInsets().right;
                    int n2 = this.getInsets().top + this.getInsets().bottom;
                    this.setSize(this.viewport.scaledWidth + n, this.viewport.scaledHeight + n2);
                }
                this.repositionViewport();
                this.lastScaleFactor = string;
            }
        }
        if (this.isVisible()) {
            this.toFront();
            this.requestFocus();
        }
    }

    public void handleFullscreenTimeout() {
        DesktopWindow desktopWindow = this;
        assert (desktopWindow != null);
        desktopWindow.delayedFullscreen = false;
        if (desktopWindow.delayedDesktopSize) {
            desktopWindow.handleDesktopSize();
            desktopWindow.delayedDesktopSize = false;
        }
    }
}

