#!BPY

""" 
Name: '3d_view_color_pallet'
Blender: 248
Group: 'Materials'
Tooltip: 'make a color palet in the 3d view'
"""

__author__ = "The Unknown Writer"
__url__ = [""]

__bpydoc__ = """\

This script makes a color palet on two triangulated mesh.
"""
#renamed from script called Alpha
# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
import Blender
from Blender import NMesh, Material

mat=Material.New()
mat.rgbCol=[1.0,1.0,1.0]
mat.mode=Material.Modes.VCOL_PAINT 
# Also tried mixing in combos of | Material.Modes.RAYTRANSP | Material.Modes.ZTRANSP | Material.Modes.ZINVERT
# but to no effect

mesh = NMesh.GetRaw()
mesh.materials.append(mat)
mesh.hasVertexColours(1)

mesh.verts.append(NMesh.Vert( 4.0,-4.0,0.0))
mesh.verts.append(NMesh.Vert(-4.0,-4.0,0.0))
mesh.verts.append(NMesh.Vert( 0.0, 4.0,0.0))
mesh.verts.append(NMesh.Vert( 4.0,-4.0,1.1))
mesh.verts.append(NMesh.Vert(-4.0,-4.0,1.1))
mesh.verts.append(NMesh.Vert( 0.0, 4.0,1.1))

f0=NMesh.Face()
f0.transp=NMesh.FaceTranspModes.ALPHA
f0.smooth=1
f0.mat=0
f0.v.append(mesh.verts[0])
f0.v.append(mesh.verts[1])
f0.v.append(mesh.verts[2])
f0.col.append(NMesh.Col(255,0,0,64))
f0.col.append(NMesh.Col(0,255,0,64))
f0.col.append(NMesh.Col(0,0,255,64))
mesh.faces.append(f0)

f1=NMesh.Face()
f1.transp=NMesh.FaceTranspModes.ALPHA
f1.smooth=1
f1.mat=0
f1.v.append(mesh.verts[3])
f1.v.append(mesh.verts[4])
f1.v.append(mesh.verts[5])
f1.col.append(NMesh.Col(0,255,255,64))
f1.col.append(NMesh.Col(255,0,255,64))
f1.col.append(NMesh.Col(255,255,0,64))
mesh.faces.append(f1)

NMesh.PutRaw(mesh,"alphatest",1)
Blender.Redraw()
