function latexnames = genlatexnames(names)
%------------------------------------------------
%2013/06/26 version 1.0
%latexnames = genlatexnames(names)
%Generates proper names for latex commandos
%------------------------------------------------
% author: Alexander Michel
% date: 2013/06/26
%
% Copyright 2010 Thomas Knig, Alexander Michel
%
% This file is part of NumericPlots.
%
% NumericPlots is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% any later version.
% 
% NumericPlots is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with NumericPlots.  If not, see <http://www.gnu.org/licenses/>.
% 

excludelist = {'\','_','-','1','2','3','4','5','6','7','8','9','0'};
for ii = 1:length(names)
    idx = [];
    teststr = names{ii};
    strlength = length(teststr);
    for jj=1:length(excludelist)
        idx = [idx strfind(teststr,excludelist{jj})];
    end
    latexnames{ii} = teststr(setdiff(1:strlength,idx));
end
        