/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.ascape.model.space.Discrete;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.util.Conditional;

public class BFSWithinIterator
implements Iterator {
    Location origin;
    Conditional condition;
    boolean includeSelf;
    int distance;
    Collection visited;
    private Collection currentSearch;
    Collection nextSearch;
    private int depth;
    Location nextLocation;
    private Iterator searchIterator;
    private int lastDepth;
    private Discrete space;
    private boolean loadedNext;

    public BFSWithinIterator(Discrete space, Location origin, Conditional condition, boolean includeSelf, double distance) {
        this.space = space;
        this.origin = origin;
        this.condition = condition;
        this.includeSelf = includeSelf;
        this.distance = (int)distance;
        this.visited = new HashSet();
        this.depth = 0;
        this.lastDepth = 0;
        this.initialize();
    }

    protected void initialize() {
        this.currentSearch = new HashSet();
        this.nextSearch = new HashSet();
        if (this.includeSelf) {
            ArrayList<Location> start = new ArrayList<Location>();
            start.add(this.origin);
            this.visited.add(this.origin);
            this.searchIterator = start.iterator();
        } else {
            ++this.depth;
            this.visited.add(this.origin);
            this.searchIterator = ((Node)this.origin).findNeighbors().iterator();
        }
    }

    public void loadNext() {
        this.nextLocation = null;
        while (this.nextLocation == null && this.searchIterator.hasNext() && this.depth <= this.distance) {
            Node candidate = (Node)this.searchIterator.next();
            this.visit(candidate);
            if (this.condition == null || this.condition.meetsCondition(candidate)) {
                this.lastDepth = this.depth;
                this.nextLocation = candidate;
            }
            if (this.searchIterator.hasNext()) continue;
            ++this.depth;
            this.searchIterator = this.nextDepth();
        }
    }

    public void visit(Node candidate) {
        this.nextSearch.addAll(candidate.findNeighbors());
    }

    public Iterator nextDepth() {
        this.nextSearch.removeAll(this.visited);
        this.visited.addAll(this.nextSearch);
        this.currentSearch.clear();
        this.currentSearch.addAll(this.nextSearch);
        this.nextSearch.clear();
        return this.currentSearch.iterator();
    }

    public boolean hasNext() {
        if (!this.loadedNext) {
            this.loadNext();
            this.loadedNext = true;
        }
        return this.nextLocation != null;
    }

    public Object next() {
        if (!this.loadedNext) {
            this.loadNext();
        }
        this.loadedNext = false;
        Location result = this.nextLocation;
        return result;
    }

    public Discrete getSpace() {
        return this.space;
    }

    public int getDepth() {
        return this.lastDepth;
    }

    protected int getInternalDepth() {
        return this.depth;
    }

    protected void setDepth(int depth) {
        this.depth = depth;
    }

    protected void setLastDepth(int lastDepth) {
        this.lastDepth = lastDepth;
    }

    public Location getOrigin() {
        return this.origin;
    }

    protected Collection getVisited() {
        return this.visited;
    }

    public Iterator getSearchIterator() {
        return this.searchIterator;
    }

    public void setSearchIterator(Iterator searchIterator) {
        this.searchIterator = searchIterator;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can't remove from within currentSearchIterator.");
    }
}

