/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleGroupElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;

public class GroupPropertyHandle {
    protected ElementPropertyDefn propDefn = null;
    protected GroupElementHandle handle = null;

    GroupPropertyHandle(GroupElementHandle handle, ElementPropertyDefn propDefn) {
        assert (propDefn != null);
        assert (handle instanceof SimpleGroupElementHandle);
        this.handle = handle;
        this.propDefn = propDefn;
    }

    public final boolean shareSameValue() {
        Iterator iter = this.handle.getElements().iterator();
        if (!iter.hasNext()) {
            return false;
        }
        DesignElementHandle elemHandle = (DesignElementHandle)iter.next();
        Object baseValue = this.getPropertyValue(elemHandle);
        while (iter.hasNext()) {
            elemHandle = (DesignElementHandle)iter.next();
            Object value = this.getPropertyValue(elemHandle);
            if (Objects.equals(baseValue, value)) continue;
            return false;
        }
        return true;
    }

    private Object getPropertyValue(DesignElementHandle elementHandle) {
        if (this.propDefn.getTypeCode() == 16) {
            return elementHandle.getProperty(this.propDefn.getName());
        }
        if (this.propDefn.allowExpression()) {
            return elementHandle.getElement().getProperty(elementHandle.module, this.propDefn);
        }
        return elementHandle.getStringProperty(this.propDefn.getName());
    }

    public String getStringValue() {
        DesignElementHandle element = this.getSameValueElementHandle();
        if (element == null) {
            return null;
        }
        return element.getStringProperty(this.propDefn.getName());
    }

    public String getLocalStringValue() {
        Object value = this.getLocalValue();
        if (value == null) {
            return null;
        }
        DesignElementHandle element = (DesignElementHandle)this.handle.getElements().get(0);
        String localValue = this.propDefn.getStringValue(element.getEffectiveModule(), value);
        return localValue;
    }

    protected Object getLocalValue() {
        if (!this.shareSameValue()) {
            return null;
        }
        List elements = this.handle.getElements();
        int i = 0;
        while (i < elements.size()) {
            DesignElementHandle element = (DesignElementHandle)elements.get(i);
            Object value = element.getElement().getLocalProperty(element.getModule(), this.propDefn);
            if (value != null) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public String getDisplayValue() {
        if (!this.shareSameValue()) {
            return null;
        }
        List elements = this.handle.getElements();
        return ((DesignElementHandle)elements.get(0)).getDisplayProperty(this.propDefn.getName());
    }

    public void setValue(Object value) throws SemanticException {
        assert (this.handle.getModule() != null);
        ActivityStack actStack = this.handle.getModule().getActivityStack();
        actStack.startTrans(this.changePropertyMessage());
        try {
            for (DesignElementHandle elemHandle : this.handle.getElements()) {
                elemHandle.setProperty(this.propDefn.getName(), value);
            }
        }
        catch (SemanticException e) {
            actStack.rollback();
            throw e;
        }
        actStack.commit();
    }

    public void setStringValue(String value) throws SemanticException {
        this.setValue(value);
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.propDefn;
    }

    public void clearValue() throws SemanticException {
        if (this.isExtensionXMLProperty()) {
            ActivityStack actStack = this.handle.getModule().getActivityStack();
            actStack.startTrans(this.changePropertyMessage());
            try {
                for (DesignElementHandle elemHandle : this.handle.getElements()) {
                    assert (elemHandle instanceof ExtendedItemHandle);
                    ExtendedItem parent = (ExtendedItem)ModelUtil.getParent(elemHandle.getElement());
                    elemHandle.setProperty(this.propDefn.getName(), parent.getLocalProperty(parent.getRoot(), this.propDefn));
                }
            }
            catch (SemanticException e) {
                actStack.rollback();
                throw e;
            }
            actStack.commit();
        } else {
            this.setValue(null);
        }
    }

    boolean isExtensionModelProperty() {
        for (DesignElementHandle elemHandle : this.handle.getElements()) {
            if (!(elemHandle instanceof ExtendedItemHandle) || !((ExtendedItem)elemHandle.getElement()).isExtensionModelProperty(this.propDefn.getName())) continue;
            return true;
        }
        return false;
    }

    boolean isExtensionXMLProperty() {
        for (DesignElementHandle elemHandle : this.handle.getElements()) {
            if (!(elemHandle instanceof ExtendedItemHandle) || !((ExtendedItem)elemHandle.getElement()).isExtensionXMLProperty(this.propDefn.getName())) continue;
            return true;
        }
        return false;
    }

    public List getReferenceableElementList() {
        List elements = this.handle.getElements();
        if (elements == null || elements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle element = (DesignElementHandle)elements.get(0);
        PropertyHandle propHandle = element.getPropertyHandle(this.propDefn.getName());
        List retList = propHandle.getReferenceableElementList();
        return ModelUtil.sortElementsByName(retList);
    }

    public boolean equals(Object target) {
        if (!(target instanceof PropertyHandle) && !(target instanceof GroupPropertyHandle)) {
            return false;
        }
        if (target instanceof PropertyHandle) {
            DesignElementHandle targetElement = ((PropertyHandle)target).getElementHandle();
            IPropertyDefn targetPropDefn = ((PropertyHandle)target).getDefn();
            return this.handle.isInGroup(targetElement) && targetPropDefn == this.propDefn;
        }
        GroupPropertyHandle propHandle = (GroupPropertyHandle)target;
        return propHandle.handle == this.handle && propHandle.propDefn == this.getPropertyDefn();
    }

    public boolean isVisible() {
        return this.handle.isPropertyVisible(this.propDefn.getName());
    }

    public boolean isReadOnly() {
        return this.handle.isPropertyReadOnly(this.propDefn.getName());
    }

    private String changePropertyMessage() {
        return CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{this.propDefn.getDisplayName()});
    }

    public Object getValue() {
        DesignElementHandle element = this.getSameValueElementHandle();
        if (element == null) {
            return null;
        }
        if (this.propDefn.allowExpression()) {
            if (this.propDefn.isListType()) {
                assert (false);
                return null;
            }
            return element.getExpressionProperty(this.propDefn.getName()).getValue();
        }
        return element.getProperty(this.propDefn.getName());
    }

    private DesignElementHandle getSameValueElementHandle() {
        if (!this.shareSameValue()) {
            return null;
        }
        return (DesignElementHandle)this.handle.getElements().get(0);
    }
}

