/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser.treebuild;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class ContentNode
implements Cloneable {
    protected ContentNode parent = null;
    protected List<ContentNode> children = null;
    protected LinkedHashMap<String, Object> attributes = null;
    protected String name = null;
    protected boolean isCDATASection = false;
    protected String value = null;

    public ContentNode(String name) {
        this.name = name;
        this.children = new ArrayList<ContentNode>();
        this.attributes = new LinkedHashMap(6);
    }

    public void addChild(ContentNode child) {
        if (child == null) {
            return;
        }
        this.children.add(child);
        child.parent = this;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public List<ContentNode> getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.attributes;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringUtil.trimString(value);
    }

    public boolean isCDATASection() {
        if ("xml-property".equalsIgnoreCase(this.name) || "method".equalsIgnoreCase(this.name)) {
            return true;
        }
        return this.isCDATASection;
    }

    public void setCDATASection(boolean isCDATASection) {
        this.isCDATASection = isCDATASection;
    }

    public Object clone() throws CloneNotSupportedException {
        ContentNode clonedNode = (ContentNode)super.clone();
        clonedNode.attributes = new LinkedHashMap(6);
        clonedNode.attributes.putAll(this.attributes);
        if (this.children != null) {
            clonedNode.children = new ArrayList<ContentNode>();
            int i = 0;
            while (i < this.children.size()) {
                ContentNode child = this.children.get(i);
                ContentNode clonedChild = (ContentNode)child.clone();
                clonedNode.children.add(clonedChild);
                clonedChild.parent = clonedNode;
                ++i;
            }
        }
        return clonedNode;
    }
}

