/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.contentmodel;

import com.ibm.icu.util.StringTokenizer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.dtd.core.internal.DTDCorePlugin;
import org.eclipse.wst.dtd.core.internal.contentmodel.CMNodeImpl;
import org.eclipse.wst.dtd.core.internal.emf.DTDAnyContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDAttribute;
import org.eclipse.wst.dtd.core.internal.emf.DTDBasicType;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDElementContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDElementReferenceContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDEmptyContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDEnumerationType;
import org.eclipse.wst.dtd.core.internal.emf.DTDFile;
import org.eclipse.wst.dtd.core.internal.emf.DTDGroupContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDInternalEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDPCDataContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDRepeatableContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDType;
import org.eclipse.wst.dtd.core.internal.emf.impl.DTDBasicTypeImpl;
import org.eclipse.wst.dtd.core.internal.emf.impl.DTDPackageImpl;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDMetrics;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocumentation;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMEntityDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamespace;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.annotation.AnnotationMap;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMDataTypeImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMEntityDeclarationImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNodeListImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDescriptionBuilder;

public class DTDImpl {
    protected static DTDAdapterFactoryImpl dtdAdapterFactoryImpl;
    protected static CMDataTypeInfoTable cmDataTypeInfoTable;

    static {
        DTDPackageImpl.init();
        dtdAdapterFactoryImpl = new DTDAdapterFactoryImpl();
        cmDataTypeInfoTable = new CMDataTypeInfoTable();
    }

    public static CMDocument buildCMDocument(String uri) {
        DTDFile dtdFile = DTDImpl.buildDTDModel(uri);
        CMDocument cmDocument = (CMDocument)DTDImpl.getAdapter((Notifier)dtdFile);
        return cmDocument;
    }

    public static DTDFile buildDTDModel(String uri) {
        DTDUtil dtdUtil = new DTDUtil();
        dtdUtil.setexpandEntityReferences(true);
        dtdUtil.setIsTrustedBase(DTDImpl.isKnownURI(uri));
        dtdUtil.parse((ResourceSet)new ResourceSetImpl(), uri);
        return dtdUtil.getDTDFile();
    }

    public static CMDocument buildCMDocument(DTDFile dtdFile) {
        return (CMDocument)DTDImpl.getAdapter((Notifier)dtdFile);
    }

    public static CMNode getAdapter(Notifier o) {
        return (CMNode)dtdAdapterFactoryImpl.adapt(o);
    }

    public static int getMinOccurHelper(DTDRepeatableContent content) {
        int occurence = content.getOccurrence().getValue();
        boolean isOptional = occurence == 63 || occurence == 42;
        return isOptional ? 0 : 1;
    }

    public static int getMaxOccurHelper(DTDRepeatableContent content) {
        int occurence = content.getOccurrence().getValue();
        boolean isMulti = occurence == 43 || occurence == 42;
        return isMulti ? -1 : 1;
    }

    static boolean isKnownURI(String dtdURI) {
        if (dtdURI.contains(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString())) {
            return false;
        }
        String[] parts = dtdURI.split("/");
        if (parts.length < 5) {
            return false;
        }
        if (!parts[0].endsWith("file:")) {
            return false;
        }
        String[] activeContributors = DTDCorePlugin.getInstance().getKnownURIs().keySet().toArray(new String[0]);
        int i = parts.length - 2;
        while (i > 0) {
            String part = parts[i];
            int j = 0;
            while (j < activeContributors.length) {
                if (part.startsWith(activeContributors[j])) {
                    part = activeContributors[j];
                    String[] contributedUris = null;
                    contributedUris = DTDCorePlugin.getInstance().getKnownURIs().get(part);
                    if (contributedUris != null) {
                        int k = 0;
                        while (k < contributedUris.length) {
                            if (dtdURI.endsWith(contributedUris[k])) {
                                return true;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            --i;
        }
        return false;
    }

    public static class CMDataTypeInfoTable {
        protected String[] instanceValueTable = new String[DTDBasicTypeImpl.basicTypeKinds.length];
        protected String[] dataTypeNameTable;

        public CMDataTypeInfoTable() {
            this.instanceValueTable[5] = "entity";
            this.instanceValueTable[6] = "entities";
            this.instanceValueTable[7] = "nmtoken";
            this.instanceValueTable[8] = "nmtokens";
            this.dataTypeNameTable = new String[DTDBasicTypeImpl.basicTypeKinds.length];
            this.dataTypeNameTable[1] = "CDATA";
            this.dataTypeNameTable[2] = "ID";
            this.dataTypeNameTable[3] = "IDREF";
            this.dataTypeNameTable[4] = "IDREFS";
            this.dataTypeNameTable[5] = "ENTITY";
            this.dataTypeNameTable[6] = "ENTITIES";
            this.dataTypeNameTable[7] = "NMTOKEN";
            this.dataTypeNameTable[8] = "NMTOKENS";
        }

        public String getInstanceValue(DTDType dtdType) {
            int kind;
            String result = null;
            if (dtdType instanceof DTDBasicType && (kind = ((DTDBasicType)dtdType).getKind().getValue()) >= 0 && kind < DTDBasicTypeImpl.basicTypeDescriptions.length) {
                result = this.instanceValueTable[kind];
            }
            return result;
        }

        public String getDataTypeName(DTDType dtdType) {
            String result = null;
            if (dtdType instanceof DTDBasicType) {
                int kind = ((DTDBasicType)dtdType).getKind().getValue();
                if (kind >= 0 && kind < DTDBasicTypeImpl.basicTypeDescriptions.length) {
                    result = this.dataTypeNameTable[kind];
                }
            } else if (dtdType instanceof DTDEnumerationType) {
                result = "ENUM";
            }
            return result;
        }
    }

    public static class CMDocumentationImpl
    implements CMDocumentation {
        protected String value;

        public CMDocumentationImpl(String value) {
            this.value = value;
        }

        public String getNodeName() {
            return "";
        }

        public int getNodeType() {
            return 9;
        }

        public boolean supports(String propertyName) {
            return false;
        }

        public Object getProperty(String propertyName) {
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String getLanguage() {
            return null;
        }

        public String getSource() {
            return null;
        }
    }

    public static class DTDAdapterFactoryImpl
    extends AdapterFactoryImpl {
        public Adapter createAdapter(Notifier target) {
            DTDBaseAdapter result = null;
            if (target != null) {
                if (target instanceof DTDAttribute) {
                    result = new DTDAttributeAdapter((DTDAttribute)target);
                } else if (target instanceof DTDElement) {
                    result = new DTDElementAdapter((DTDElement)target);
                } else if (target instanceof DTDElementReferenceContent) {
                    result = new DTDElementReferenceContentAdapter((DTDElementReferenceContent)target);
                } else if (target instanceof DTDFile) {
                    result = new DTDFileAdapter((DTDFile)target);
                } else if (target instanceof DTDGroupContent) {
                    result = new DTDGroupContentAdapter((DTDGroupContent)target);
                } else if (target instanceof DTDEntity) {
                    result = new DTDEntityAdapter((DTDEntity)target);
                }
            }
            return result;
        }

        public synchronized Adapter adapt(Notifier target) {
            return this.adapt(target, (Object)this);
        }
    }

    public static class DTDAttributeAdapter
    extends DTDBaseAdapter
    implements CMAttributeDeclaration {
        protected DTDAttribute attribute;
        protected CMDataType dataType;

        public DTDAttributeAdapter(DTDAttribute attribute) {
            this.attribute = attribute;
            this.dataType = new DataTypeImpl();
        }

        @Override
        public Object getKey() {
            return this.attribute;
        }

        @Override
        public String getSpec() {
            return String.valueOf(this.attribute.getDTDElement().getName()) + "/@" + this.attribute.getName();
        }

        public int getNodeType() {
            return 2;
        }

        @Override
        public String getNodeName() {
            return this.attribute.getName();
        }

        public String getAttrName() {
            return this.attribute.getName();
        }

        public CMDataType getAttrType() {
            return this.dataType;
        }

        public String getDefaultValue() {
            return this.attribute.getDefaultValueString();
        }

        public Enumeration getEnumAttr() {
            return Collections.enumeration(this.attribute.getEnumeratedValues());
        }

        public int getUsage() {
            int usage = 1;
            switch (this.attribute.getDefaultKind().getValue()) {
                case 2: {
                    usage = 2;
                    break;
                }
                case 3: {
                    usage = 3;
                }
            }
            return usage;
        }

        @Override
        public CMDocument getCMDocument() {
            DTDFile dtdFile = this.attribute.getDTDElement().getDTDFile();
            return dtdFile != null ? (CMDocument)DTDImpl.getAdapter((Notifier)dtdFile) : null;
        }

        public class DataTypeImpl
        implements CMDataType {
            public int getNodeType() {
                return 3;
            }

            public String getNodeName() {
                return this.getDataTypeName();
            }

            public boolean supports(String propertyName) {
                return false;
            }

            public Object getProperty(String propertyName) {
                String result = null;
                if (propertyName.equals("isValidEmptyValue")) {
                    String dataTypeName = this.getDataTypeName();
                    result = dataTypeName == null || dataTypeName.equals("CDATA") ? "true" : "false";
                }
                return result;
            }

            public String getDataTypeName() {
                return cmDataTypeInfoTable.getDataTypeName(DTDAttributeAdapter.this.attribute.getDTDType());
            }

            public String generateInstanceValue() {
                return cmDataTypeInfoTable.getInstanceValue(DTDAttributeAdapter.this.attribute.getDTDType());
            }

            public int getImpliedValueKind() {
                int result = 1;
                int defaultValueKind = DTDAttributeAdapter.this.attribute.getDefaultKind().getValue();
                if (defaultValueKind == 4) {
                    result = 3;
                } else if (defaultValueKind == 3) {
                    result = 2;
                }
                return result;
            }

            public String getImpliedValue() {
                return DTDAttributeAdapter.this.attribute.getDefaultValueString();
            }

            public String[] getEnumeratedValues() {
                Object[] objectList = DTDAttributeAdapter.this.attribute.getEnumeratedValues().toArray();
                String[] result = new String[objectList.length];
                int i = 0;
                while (i < objectList.length) {
                    result[i] = objectList[i].toString();
                    ++i;
                }
                return result;
            }
        }
    }

    public static abstract class DTDBaseAdapter
    extends CMNodeImpl {
        public String getNodeName() {
            return "";
        }

        public boolean isAdapterForType(Object type) {
            return type == dtdAdapterFactoryImpl;
        }

        @Override
        public Object getProperty(String propertyName) {
            Object result = null;
            if (propertyName.equals("CMDocument")) {
                result = this.getCMDocument();
            } else if (propertyName.equals("documentation")) {
                result = this.getDocumentation();
            } else if (propertyName.equals("http://org.eclipse.wst/cm/properties/definitionInfo")) {
                result = this.getDefinitionInfo();
            } else if (propertyName.equals("http://org.eclipse.wst/cm/properties/definition")) {
                result = this.getDefinition();
            } else if (propertyName.equals("key")) {
                result = this.getKey();
            } else if (propertyName.equals("spec")) {
                result = this.getSpec();
            } else {
                CMDocument cmDocument;
                result = super.getProperty(propertyName);
                if (result == null && (cmDocument = this.getCMDocument()) instanceof DTDFileAdapter) {
                    String spec;
                    AnnotationMap map = ((DTDFileAdapter)cmDocument).annotationMap;
                    if (map != null && (spec = this.getSpec()) != null) {
                        result = map.getProperty(this.getSpec(), propertyName);
                    }
                    if (result == null) {
                        Map globalPropertyMap = ((DTDFileAdapter)cmDocument).globalPropertyMap;
                        result = globalPropertyMap.get(propertyName);
                    }
                }
            }
            return result;
        }

        public CMDocument getCMDocument() {
            return null;
        }

        protected CMNodeList getDocumentation() {
            return new CMNodeListImpl();
        }

        public String getDefinitionInfo() {
            return null;
        }

        public CMNode getDefinition() {
            return null;
        }

        public String getSpec() {
            return this.getNodeName();
        }
    }

    public static class DTDElementAdapter
    extends DTDElementBaseAdapter {
        protected DTDElement element;

        public DTDElementAdapter(DTDElement element) {
            this.element = element;
            this.dataType = new CMDataTypeImpl("#PCDATA", this.getDTDElement().getName());
        }

        @Override
        public Object getKey() {
            return this.element;
        }

        @Override
        protected DTDElement getDTDElement() {
            return this.element;
        }

        public int getMinOccur() {
            if (this.element.getContent() instanceof DTDRepeatableContent) {
                return DTDImpl.getMinOccurHelper((DTDRepeatableContent)this.element.getContent());
            }
            return 1;
        }

        public int getMaxOccur() {
            if (this.element.getContent() instanceof DTDRepeatableContent) {
                return DTDImpl.getMaxOccurHelper((DTDRepeatableContent)this.element.getContent());
            }
            return 1;
        }

        @Override
        public String getDefinitionInfo() {
            return "global";
        }

        @Override
        public CMNode getDefinition() {
            return this;
        }
    }

    public static abstract class DTDElementBaseAdapter
    extends DTDBaseAdapter
    implements CMElementDeclaration {
        protected CMDataType dataType;
        protected CMDocumentation documentation = null;

        protected abstract DTDElement getDTDElement();

        public int getNodeType() {
            return 5;
        }

        @Override
        public String getNodeName() {
            return this.getDTDElement().getName();
        }

        public CMNamedNodeMap getAttributes() {
            CMNamedNodeMapImpl result = new CMNamedNodeMapImpl();
            EList attributeList = this.getDTDElement().getDTDAttribute();
            for (DTDAttribute attribute : attributeList) {
                result.getHashtable().put(attribute.getName(), DTDImpl.getAdapter((Notifier)attribute));
            }
            return result;
        }

        public CMContent getContent() {
            return (CMContent)DTDImpl.getAdapter((Notifier)this.getDTDElement().getContent());
        }

        public int getContentType() {
            int result = 2;
            DTDElementContent dtdElementContent = this.getDTDElement().getContent();
            if (dtdElementContent instanceof DTDPCDataContent) {
                result = 4;
            } else if (dtdElementContent instanceof DTDGroupContent) {
                EList list;
                DTDGroupContent groupContent = (DTDGroupContent)dtdElementContent;
                int groupKind = groupContent.getGroupKind().getValue();
                if (groupKind == 2 && (list = groupContent.getContent()).size() > 0 && list.get(0) instanceof DTDPCDataContent) {
                    result = 3;
                }
            } else if (dtdElementContent instanceof DTDAnyContent) {
                result = 0;
            } else if (dtdElementContent instanceof DTDEmptyContent) {
                result = 1;
            }
            return result;
        }

        public String getElementName() {
            return this.getDTDElement().getName();
        }

        public CMDataType getDataType() {
            int contentType = this.getContentType();
            boolean hasDataType = contentType == 4 || contentType == 3;
            return hasDataType ? this.dataType : null;
        }

        public CMNamedNodeMap getLocalElements() {
            return CMNamedNodeMapImpl.EMPTY_NAMED_NODE_MAP;
        }

        @Override
        public CMDocument getCMDocument() {
            DTDFile dtdFile = this.getDTDElement().getDTDFile();
            return dtdFile != null ? (CMDocument)DTDImpl.getAdapter((Notifier)dtdFile) : null;
        }

        @Override
        protected CMNodeList getDocumentation() {
            String comment;
            CMNodeListImpl nodeList = new CMNodeListImpl();
            if (this.documentation == null && (comment = this.getDTDElement().getComment()) != null) {
                String value = "";
                StringTokenizer st = new StringTokenizer(comment, "\n");
                while (st.hasMoreTokens()) {
                    value = String.valueOf(value) + st.nextToken().trim() + "\n";
                }
                this.documentation = new CMDocumentationImpl(value);
            }
            if (this.documentation != null) {
                nodeList.getList().add(this.documentation);
            }
            return nodeList;
        }
    }

    public static class DTDElementReferenceContentAdapter
    extends DTDElementBaseAdapter {
        protected DTDElementReferenceContent content;

        public DTDElementReferenceContentAdapter(DTDElementReferenceContent content) {
            this.content = content;
            this.dataType = new CMDataTypeImpl("#PCDATA", this.getDTDElement().getName());
        }

        @Override
        public Object getKey() {
            return this.content;
        }

        @Override
        protected DTDElement getDTDElement() {
            return this.content.getReferencedElement();
        }

        public int getMinOccur() {
            return DTDImpl.getMinOccurHelper(this.content);
        }

        public int getMaxOccur() {
            return DTDImpl.getMaxOccurHelper(this.content);
        }

        @Override
        public CMNode getDefinition() {
            return DTDImpl.getAdapter((Notifier)this.getDTDElement());
        }
    }

    public static class DTDEntityAdapter
    extends DTDBaseAdapter
    implements CMEntityDeclaration {
        protected DTDEntity dtdEntity;

        public DTDEntityAdapter(DTDEntity dtdEntity) {
            this.dtdEntity = dtdEntity;
        }

        public int getNodeType() {
            return 6;
        }

        @Override
        public Object getKey() {
            return this.dtdEntity;
        }

        public String getName() {
            return this.dtdEntity.getName();
        }

        public String getValue() {
            String value = "";
            if (this.dtdEntity.getContent() instanceof DTDInternalEntity) {
                DTDInternalEntity content = (DTDInternalEntity)this.dtdEntity.getContent();
                value = content.getValue();
            }
            return value;
        }
    }

    public static class DTDFileAdapter
    extends DTDBaseAdapter
    implements CMDocument {
        protected final String DEFAULT_ROOT_NAME = "http://org.eclipse.wst/cm/properties/defaultRootName";
        protected DTDFile dtdFile;
        protected CMNamedNodeMapImpl namedNodeMap;
        protected CMNamedNodeMapImpl entityNodeMap;
        protected AnnotationMap annotationMap = new AnnotationMap();
        protected Map globalPropertyMap = new HashMap();

        public DTDFileAdapter(DTDFile dtdFile) {
            this.dtdFile = dtdFile;
        }

        @Override
        public Object getKey() {
            return this.dtdFile;
        }

        public AnnotationMap getAnnotationMap() {
            return this.annotationMap;
        }

        public CMNamedNodeMap getElements() {
            if (this.namedNodeMap == null) {
                this.namedNodeMap = new CMNamedNodeMapImpl();
                for (DTDElement dtdElement : this.dtdFile.listDTDElement()) {
                    this.namedNodeMap.getHashtable().put(dtdElement.getName(), DTDImpl.getAdapter((Notifier)dtdElement));
                }
            }
            return this.namedNodeMap;
        }

        public CMNamedNodeMap getEntities() {
            if (this.entityNodeMap == null) {
                this.entityNodeMap = new CMNamedNodeMapImpl();
                this.entityNodeMap.getHashtable().put("amp", new CMEntityDeclarationImpl("amp", "&"));
                this.entityNodeMap.getHashtable().put("lt", new CMEntityDeclarationImpl("lt", "<"));
                this.entityNodeMap.getHashtable().put("gt", new CMEntityDeclarationImpl("gt", ">"));
                this.entityNodeMap.getHashtable().put("quot", new CMEntityDeclarationImpl("quot", "\""));
                this.entityNodeMap.getHashtable().put("apos", new CMEntityDeclarationImpl("apos", "'"));
                for (DTDEntity dtdEntity : this.dtdFile.listDTDEntity()) {
                    if (dtdEntity.isParameterEntity() || dtdEntity.getName() == null || !(dtdEntity.getContent() instanceof DTDInternalEntity)) continue;
                    this.entityNodeMap.getHashtable().put(dtdEntity.getName(), DTDImpl.getAdapter((Notifier)dtdEntity));
                }
            }
            return this.entityNodeMap;
        }

        public CMNamespace getNamespace() {
            return null;
        }

        public int getNodeType() {
            return 4;
        }

        @Override
        public String getNodeName() {
            return String.valueOf(this.dtdFile.getName()) + ".dtd";
        }

        @Override
        public Object getProperty(String propertyName) {
            Object result = null;
            if (propertyName.equals("http://org.eclipse.wst/cm/properties/defaultRootName")) {
                DTDMetrics metrics = new DTDMetrics(this.dtdFile);
                DTDElement dtdElement = metrics.getLeastReferencedElement();
                if (dtdElement != null) {
                    result = dtdElement.getName();
                }
            } else {
                result = propertyName.equals("annotationMap") ? this.annotationMap : (propertyName.equals("globalPropertyMap") ? this.globalPropertyMap : super.getProperty(propertyName));
            }
            return result;
        }
    }

    public static class DTDGroupContentAdapter
    extends DTDBaseAdapter
    implements CMGroup {
        protected DTDGroupContent content;

        public DTDGroupContentAdapter(DTDGroupContent content) {
            this.content = content;
        }

        @Override
        public Object getKey() {
            return this.content;
        }

        public int getNodeType() {
            return 7;
        }

        @Override
        public String getNodeName() {
            CMDescriptionBuilder descriptionBuilder = new CMDescriptionBuilder();
            return descriptionBuilder.buildDescription((CMNode)this);
        }

        public CMNodeList getChildNodes() {
            EList list = this.content.getContent();
            CMNodeListImpl result = new CMNodeListImpl();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                CMNode node = DTDImpl.getAdapter((Notifier)i.next());
                if (node == null) continue;
                result.getList().add(node);
            }
            return result;
        }

        public int getMaxOccur() {
            return DTDImpl.getMaxOccurHelper(this.content);
        }

        public int getMinOccur() {
            return DTDImpl.getMinOccurHelper(this.content);
        }

        public int getOperator() {
            int groupKind = this.content.getGroupKind().getValue();
            return groupKind == 2 ? 2 : 1;
        }
    }
}

