/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.generic.gdiffdata.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.IRawDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GMapping;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GMatch;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GdiffdataPackage;
import org.eclipse.emf.diffmerge.generic.gdiffdata.impl.GIdentifiedImpl;
import org.eclipse.emf.diffmerge.generic.impl.helpers.BidirectionalComparisonCopier;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class GMappingImpl<E, A, R>
extends GIdentifiedImpl
implements GMapping<E, A, R> {
    protected EList<GMatch<E, A, R>> modifiableContents;
    protected EList<IMatch<E>> referenceCompletedMatches;
    protected EList<IMatch<E>> targetCompletedMatches;
    private final BidirectionalComparisonCopier<E> _copier = new BidirectionalComparisonCopier();

    protected GMappingImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GdiffdataPackage.Literals.GMAPPING;
    }

    @Override
    public EList<GMatch<E, A, R>> getModifiableContents() {
        if (this.modifiableContents == null) {
            this.modifiableContents = new EObjectContainmentEList(GMatch.class, (InternalEObject)this, 1);
        }
        return this.modifiableContents;
    }

    @Override
    public EList<IMatch<E>> getReferenceCompletedMatches() {
        if (this.referenceCompletedMatches == null) {
            this.referenceCompletedMatches = new EObjectEList(IMatch.class, (InternalEObject)this, 2);
        }
        return this.referenceCompletedMatches;
    }

    @Override
    public EList<IMatch<E>> getTargetCompletedMatches() {
        if (this.targetCompletedMatches == null) {
            this.targetCompletedMatches = new EObjectEList(IMatch.class, (InternalEObject)this, 3);
        }
        return this.targetCompletedMatches;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getModifiableContents()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getModifiableContents();
            }
            case 2: {
                return this.getReferenceCompletedMatches();
            }
            case 3: {
                return this.getTargetCompletedMatches();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getModifiableContents().clear();
                this.getModifiableContents().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getReferenceCompletedMatches().clear();
                this.getReferenceCompletedMatches().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getTargetCompletedMatches().clear();
                this.getTargetCompletedMatches().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getModifiableContents().clear();
                return;
            }
            case 2: {
                this.getReferenceCompletedMatches().clear();
                return;
            }
            case 3: {
                this.getTargetCompletedMatches().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.modifiableContents != null && !this.modifiableContents.isEmpty();
            }
            case 2: {
                return this.referenceCompletedMatches != null && !this.referenceCompletedMatches.isEmpty();
            }
            case 3: {
                return this.targetCompletedMatches != null && !this.targetCompletedMatches.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void clear() {
        this.getModifiableContents().clear();
        this.getTargetCompletedMatches().clear();
        this.getReferenceCompletedMatches().clear();
    }

    @Override
    public E completeMatch(IMatch<E> partialMatch_p) {
        return this._copier.completeMatch(this, partialMatch_p);
    }

    @Override
    public void completeReferences(Role role_p) {
        this._copier.completeReferences(this, role_p);
    }

    @Override
    public boolean covers(E element_p, Role role_p) {
        return this.getMatchFor(element_p, role_p) != null;
    }

    @Override
    public Collection<IMatch<E>> getCompletedMatches(Role destinationRole_p) {
        return Collections.unmodifiableCollection(this.getModifiableCompletedMatches(destinationRole_p));
    }

    @Override
    public GComparison<E, A, R> getComparison() {
        GComparison result = null;
        EObject container = this.eContainer();
        if (container instanceof GComparison) {
            result = (GComparison)container;
        }
        return result;
    }

    @Override
    public Collection<IMatch<E>> getContents() {
        return Collections.unmodifiableCollection(this.getModifiableContents());
    }

    @Override
    public Collection<IMatch<E>> getModifiableCompletedMatches(Role destinationRole_p) {
        return Role.TARGET == destinationRole_p ? this.getTargetCompletedMatches() : this.getReferenceCompletedMatches();
    }

    @Override
    public int getNbFullMatches() {
        int result = 0;
        for (IMatch<E> match : this.getContents()) {
            if (match.isPartial()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getNbPartialMatches(Role covered_p) {
        int result = 0;
        for (IMatch<E> match : this.getContents()) {
            if (!match.isPartial() || covered_p != null && !match.coversRole(covered_p)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public Role getOrderingRole() {
        return Role.TARGET;
    }

    @Override
    public boolean isCompleteFor(IRawDataScope<E> scope_p, Role role_p) {
        for (E currentInScope : scope_p) {
            if (this.covers(currentInScope, role_p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getModifiableContents().isEmpty();
    }

    @Override
    public boolean isIgnoredReferenceValue(E source_p, R reference_p, E value_p, Role role_p) {
        boolean result = false;
        IMatch referencingMatch = this.getMatchFor(source_p, role_p);
        IMatch referencedMatch = this.getMatchFor(value_p, role_p);
        if (referencingMatch != null && referencedMatch != null) {
            result = referencingMatch.isPartial() && referencedMatch.isPartial();
        }
        return result;
    }

    @Override
    public boolean disconnect(Role role_p, E element_p) {
        boolean result = true;
        IEditableTreeDataScope scope = this.getComparison().getScope(role_p);
        if (scope.tIsElementDisconnectionRequired()) {
            result = this.doDisconnect(role_p, element_p);
        }
        return result;
    }

    protected abstract boolean doDisconnect(Role var1, E var2);

    @Override
    public GMatch<E, A, R> map(E element_p, Role role_p) {
        assert (element_p != null && role_p != null);
        IMatch previous = this.getMatchFor(element_p, role_p);
        if (previous != null) {
            this.getModifiableContents().remove((Object)previous);
        }
        GMatch result = (GMatch)this.getComparison().newMatch(Role.TARGET == role_p ? element_p : null, Role.REFERENCE == role_p ? element_p : null, Role.ANCESTOR == role_p ? element_p : null);
        this.getModifiableContents().add((Object)result);
        return result;
    }

    @Override
    public boolean mapIncrementally(E element1_p, Role role1_p, E element2_p, Role role2_p) {
        IMatch found;
        assert (role1_p != null && role2_p != null && role1_p != role2_p);
        IMatch newMatch = null;
        boolean result = false;
        HashMap<Role, E> elements = new HashMap<Role, E>(3);
        elements.put(role1_p, element1_p);
        elements.put(role2_p, element2_p);
        Role role3 = Role.otherThan(role1_p, role2_p);
        Object element3 = null;
        if (element1_p != null && (newMatch = this.getMatchFor(element1_p, role1_p)) != null) {
            element3 = newMatch.get(role3);
            Object foundElement2 = newMatch.get(role2_p);
            boolean bl = result = foundElement2 != null && foundElement2 != element2_p;
        }
        if (element2_p != null && (found = this.getMatchFor(element2_p, role2_p)) != null) {
            Object foundElement1 = found.get(role1_p);
            result = result || foundElement1 != null && foundElement1 != element1_p;
            Object inRole3 = found.get(role3);
            if (inRole3 != null) {
                element3 = inRole3;
            }
            if (newMatch != null && newMatch != found) {
                this.getModifiableContents().remove((Object)found);
            } else {
                newMatch = found;
            }
        }
        elements.put(role3, element3);
        if (newMatch == null) {
            newMatch = this.getComparison().newMatch(elements.get((Object)Role.TARGET), elements.get((Object)Role.REFERENCE), elements.get((Object)Role.ANCESTOR));
            this.getModifiableContents().add((Object)((GMatch)newMatch));
        } else {
            ((IMatch.Editable)newMatch).reset(elements.get((Object)Role.TARGET), elements.get((Object)Role.REFERENCE), elements.get((Object)Role.ANCESTOR));
        }
        return result;
    }

    @Override
    public boolean maps(E target_p, E reference_p) {
        return this.maps(target_p, Role.TARGET, reference_p, Role.REFERENCE);
    }

    @Override
    public boolean maps(E target_p, E reference_p, E ancestor_p) {
        return this.maps(ancestor_p, Role.ANCESTOR, target_p, Role.TARGET) && this.maps(ancestor_p, Role.ANCESTOR, reference_p, Role.REFERENCE) && this.maps(target_p, Role.TARGET, reference_p, Role.REFERENCE);
    }

    @Override
    public boolean maps(E element1_p, Role role1_p, E element2_p, Role role2_p) {
        boolean result = false;
        if (element1_p != null) {
            IMatch fromElement1 = this.getMatchFor(element1_p, role1_p);
            result = fromElement1 != null && fromElement1.get(role2_p) == element2_p;
        } else if (element2_p != null) {
            IMatch fromElement2 = this.getMatchFor(element2_p, role2_p);
            result = fromElement2 != null && fromElement2.get(role1_p) == element1_p;
        }
        return result;
    }

    @Override
    public int size() {
        return this.getContents().size();
    }

    @Override
    public int size(Role role_p) {
        int result = 0;
        for (GMatch match : this.getModifiableContents()) {
            if (match.get(role_p) == null) continue;
            ++result;
        }
        return result;
    }

    @Override
    public EMap<E, E> toMap(Role keyRole_p, Role valueRole_p) {
        FHashMap result = new FHashMap();
        for (IMatch<E> match : this.getContents()) {
            Object key = match.get(keyRole_p);
            if (key == null) continue;
            result.put(key, match.get(valueRole_p));
        }
        return ECollections.unmodifiableEMap((EMap)result);
    }
}

