/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.policies;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecoretools.diagram.edit.commands.RemoveDiagramCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.notation.MultiDiagramLinkStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class PackageComponentEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteViewCommand(GroupRequest deleteRequest) {
        CompositeCommand cc = new CompositeCommand(null);
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        List toDel = deleteRequest.getEditParts();
        if (toDel == null || toDel.isEmpty()) {
            this.deleteLinkedDiagram(cc, this.getHost());
            cc.compose((IUndoableOperation)new DeleteCommand(editingDomain, (View)this.getHost().getModel()));
        } else {
            int i = 0;
            while (i < toDel.size()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)toDel.get(i);
                this.deleteLinkedDiagram(cc, (EditPart)gep);
                cc.compose((IUndoableOperation)new DeleteCommand(editingDomain, (View)gep.getModel()));
                ++i;
            }
        }
        return new ICommandProxy(cc.reduce());
    }

    private void deleteLinkedDiagram(CompositeCommand cc, EditPart editPart) {
        View view = (View)editPart.getModel();
        MultiDiagramLinkStyle style = (MultiDiagramLinkStyle)view.getStyle(NotationPackage.eINSTANCE.getMultiDiagramLinkStyle());
        if (style != null) {
            cc.compose((IUndoableOperation)new RemoveDiagramCommand(style));
        }
    }

    private TransactionalEditingDomain getEditingDomain() {
        EditingDomain domain;
        if (this.getHost() instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        }
        if (this.getHost() instanceof IEditingDomainProvider && (domain = ((IEditingDomainProvider)this.getHost()).getEditingDomain()) instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)domain;
        }
        return null;
    }
}

