/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.enterprise.chain;

import jakarta.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.chain.Foo;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.chain.Qux;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0")
public class SessionBeanInjectionChainTest
extends AbstractTest {
    @Inject
    Qux qux;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionBeanInjectionChainTest.class)).build();
    }

    @Test
    @SpecAssertion(section="injection_and_resolution", id="b")
    public void testChainOfSessionBeans() {
        Assert.assertNotNull((Object)this.qux);
        Assert.assertEquals((int)this.qux.ping(0), (int)4);
        Assert.assertEquals((int)this.qux.getBaz().ping(0), (int)3);
        Foo foo = this.qux.getBaz().getBar().getFoo();
        Assert.assertNotNull((Object)foo);
        Assert.assertEquals((int)foo.getBaz().ping(0), (int)3);
        Assert.assertEquals((int)foo.getBaz().getBar().ping(0), (int)2);
        Assert.assertEquals((int)foo.getBaz().getQux().ping(0), (int)4);
    }
}

