/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import java.util.ArrayList;
import java.util.Collection;

class LangModelUtils {
    LangModelUtils() {
    }

    static ClassInfo classOfField(ClassInfo clazz, String fieldName) {
        return LangModelUtils.singleField(clazz, fieldName).type().asClass().declaration();
    }

    static FieldInfo singleField(ClassInfo clazz, String name) {
        FieldInfo result = null;
        for (FieldInfo field : clazz.fields()) {
            if (!name.equals(field.name())) continue;
            if (result == null) {
                result = field;
                continue;
            }
            throw new IllegalStateException("More than 1 declaration of field '" + name + "' on '" + clazz.simpleName() + "'");
        }
        if (result == null) {
            throw new IllegalStateException("No declaration of field '" + name + "' on '" + clazz.simpleName() + "'");
        }
        return result;
    }

    static FieldInfo singleDeclaredField(ClassInfo clazz, String name) {
        FieldInfo result = null;
        for (FieldInfo field : clazz.fields()) {
            if (!field.declaringClass().equals(clazz) || !name.equals(field.name())) continue;
            if (result == null) {
                result = field;
                continue;
            }
            throw new IllegalStateException("More than 1 declaration of field '" + name + "' on '" + clazz.simpleName() + "'");
        }
        if (result == null) {
            throw new IllegalStateException("No declaration of field '" + name + "' on '" + clazz.simpleName() + "'");
        }
        return result;
    }

    static Collection<FieldInfo> collectFields(ClassInfo clazz, String name) {
        ArrayList<FieldInfo> result = new ArrayList<FieldInfo>();
        for (FieldInfo field : clazz.fields()) {
            if (!field.name().equals(name)) continue;
            result.add(field);
        }
        return result;
    }

    static MethodInfo singleMethod(ClassInfo clazz, String name) {
        MethodInfo result = null;
        for (MethodInfo method : clazz.methods()) {
            if (!name.equals(method.name())) continue;
            if (result == null) {
                result = method;
                continue;
            }
            throw new IllegalStateException("More than 1 declaration of method '" + name + "' on '" + clazz.simpleName() + "'");
        }
        if (result == null) {
            throw new IllegalStateException("No declaration of method '" + name + "' on '" + clazz.simpleName() + "'");
        }
        return result;
    }

    static MethodInfo singleDeclaredMethod(ClassInfo clazz, String name) {
        MethodInfo result = null;
        for (MethodInfo method : clazz.methods()) {
            if (!method.declaringClass().equals(clazz) || !name.equals(method.name())) continue;
            if (result == null) {
                result = method;
                continue;
            }
            throw new IllegalStateException("More than 1 declaration of method '" + name + "' on '" + clazz.simpleName() + "'");
        }
        if (result == null) {
            throw new IllegalStateException("No declaration of method '" + name + "' on '" + clazz.simpleName() + "'");
        }
        return result;
    }

    static Collection<MethodInfo> collectMethods(ClassInfo clazz, String name) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (MethodInfo method : clazz.methods()) {
            if (!method.name().equals(name)) continue;
            result.add(method);
        }
        return result;
    }
}

