/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util.annotated;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cdi.tck.util.annotated.AnnotatedConstructorWrapper;
import org.jboss.cdi.tck.util.annotated.AnnotatedFieldWrapper;
import org.jboss.cdi.tck.util.annotated.AnnotatedMethodWrapper;
import org.jboss.cdi.tck.util.annotated.AnnotatedWrapper;

public class AnnotatedTypeWrapper<X>
extends AnnotatedWrapper
implements AnnotatedType<X> {
    private AnnotatedType<X> delegate;
    private Set<AnnotatedConstructor<X>> constructors;
    private Set<AnnotatedField<? super X>> fields;
    private Set<AnnotatedMethod<? super X>> methods;

    public AnnotatedTypeWrapper(AnnotatedType<X> delegate, boolean keepOriginalAnnotations, Annotation ... annotations) {
        super((Annotated)delegate, keepOriginalAnnotations, annotations);
        this.delegate = delegate;
        this.constructors = new HashSet<AnnotatedConstructor<X>>();
        for (AnnotatedConstructor constructor : delegate.getConstructors()) {
            this.constructors.add(new AnnotatedConstructorWrapper(constructor, this, true, constructor.getAnnotations().toArray(new Annotation[0])));
        }
        this.fields = new HashSet<AnnotatedField<? super X>>();
        for (AnnotatedField field : delegate.getFields()) {
            this.fields.add(new AnnotatedFieldWrapper(field, this, true, field.getAnnotations().toArray(new Annotation[0])));
        }
        this.methods = new HashSet<AnnotatedMethod<? super X>>();
        for (AnnotatedMethod method : delegate.getMethods()) {
            this.methods.add(new AnnotatedMethodWrapper(method, this, true, method.getAnnotations().toArray(new Annotation[0])));
        }
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.constructors;
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return this.fields;
    }

    public Class<X> getJavaClass() {
        return this.delegate.getJavaClass();
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.methods;
    }
}

