/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.Launcher;
import com.sun.enterprise.glassfish.bootstrap.StartupContextCfgFactory;
import com.sun.enterprise.glassfish.bootstrap.cfg.AsenvConf;
import com.sun.enterprise.glassfish.bootstrap.cfg.OsgiPlatform;
import com.sun.enterprise.glassfish.bootstrap.cfg.ServerFiles;
import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextCfg;
import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextUtil;
import com.sun.enterprise.glassfish.bootstrap.cp.ClassLoaderBuilder;
import com.sun.enterprise.glassfish.bootstrap.cp.GlassfishBootstrapClassLoader;
import com.sun.enterprise.glassfish.bootstrap.log.LogFacade;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Properties;
import java.util.logging.Level;

public class GlassFishMain {
    private static final String ENV_AS_TRACE_LOGGING = "AS_TRACE_LOGGING";
    private static final String ENV_AS_TRACE_BOOTSTRAP = "AS_TRACE_BOOTSTRAP";
    private static final String DEFAULT_DOMAINS_DIR_PROPNAME = "AS_DEF_DOMAINS_PATH";
    private static final PrintStream STDOUT = System.out;

    public static void main(String[] args) {
        try {
            File installRoot = StartupContextUtil.detectInstallRoot();
            ClassLoader jdkExtensionCL = ClassLoader.getSystemClassLoader().getParent();
            GlassfishBootstrapClassLoader gfBootCL = new GlassfishBootstrapClassLoader(installRoot, jdkExtensionCL);
            GlassFishMain.initializeLogManager(gfBootCL);
            GlassFishMain.checkJdkVersion();
            Properties argsAsProps = ArgumentManager.argsToMap(args);
            String platformName = GlassFishMain.whichPlatform();
            OsgiPlatform platform = OsgiPlatform.valueOf(platformName);
            STDOUT.println("Launching GlassFish on " + platform + " platform");
            System.setProperty("GlassFish_Platform", platformName);
            Path instanceRoot = GlassFishMain.findInstanceRoot(installRoot, argsAsProps);
            ServerFiles files = new ServerFiles(installRoot.toPath(), instanceRoot);
            StartupContextCfg startupContextCfg = StartupContextCfgFactory.createStartupContextCfg(platform, files, args);
            ClassLoader launcherCL = ClassLoaderBuilder.createLauncherCL(startupContextCfg, gfBootCL);
            Class<?> launcherClass = launcherCL.loadClass(Launcher.class.getName());
            Object launcher = launcherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = launcherClass.getMethod("launch", Properties.class);
            method.invoke(launcher, startupContextCfg.toProperties());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Could not start the server!", t);
        }
    }

    private static void initializeLogManager(GlassfishBootstrapClassLoader gfMainCL) throws Exception {
        Class<?> loggingInitializer = gfMainCL.loadClass("org.glassfish.main.jul.GlassFishLogManagerInitializer");
        Properties loggingCfg = GlassFishMain.createDefaultLoggingProperties();
        loggingInitializer.getMethod("tryToSetAsDefault", Properties.class).invoke(loggingInitializer, loggingCfg);
    }

    private static void checkJdkVersion() {
        int version = Runtime.version().feature();
        if (version < 11) {
            LogFacade.BOOTSTRAP_LOGGER.log(Level.SEVERE, "NCLS-BOOTSTRAP-00001", new Object[]{11, version});
            System.exit(1);
        }
    }

    private static String whichPlatform() {
        String platformSysOption = System.getProperty("GlassFish_Platform");
        if (platformSysOption != null && !platformSysOption.isBlank()) {
            return platformSysOption.trim();
        }
        String platformEnvOption = System.getenv("GlassFish_Platform");
        if (platformEnvOption != null && !platformEnvOption.isBlank()) {
            return platformEnvOption.trim();
        }
        return OsgiPlatform.Felix.name();
    }

    private static Path findInstanceRoot(File installRoot, Properties args) {
        File instanceDir = GlassFishMain.getInstanceRoot(args);
        if (instanceDir == null) {
            instanceDir = GlassFishMain.getDomainRoot(args, installRoot);
        }
        GlassFishMain.verifyDomainRoot(instanceDir);
        return instanceDir.toPath();
    }

    private static File getInstanceRoot(Properties args) {
        String instanceDir = GlassFishMain.getParam(args, "instancedir");
        if (GlassFishMain.isSet(instanceDir)) {
            return new File(instanceDir);
        }
        return null;
    }

    private static File getDomainRoot(Properties args, File installRoot) {
        String domainDir = GlassFishMain.getParam(args, "domaindir");
        if (GlassFishMain.isSet(domainDir)) {
            return new File(domainDir);
        }
        File defDomainsRoot = GlassFishMain.getDefaultDomainsDir(installRoot);
        String domainName = GlassFishMain.getParam(args, "domain");
        if (GlassFishMain.isSet(domainName)) {
            return new File(defDomainsRoot, domainName);
        }
        return GlassFishMain.getDefaultDomain(defDomainsRoot);
    }

    private static File getDefaultDomainsDir(File installRoot) {
        AsenvConf asEnv = AsenvConf.parseAsEnv(installRoot);
        String dirname = asEnv.getProperty(DEFAULT_DOMAINS_DIR_PROPNAME);
        if (!GlassFishMain.isSet(dirname)) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH is not set.");
        }
        File domainsDir = GlassFishMain.absolutize(new File(dirname));
        if (!domainsDir.isDirectory()) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH[" + dirname + "] is specifying a file that is NOT a directory.");
        }
        return domainsDir;
    }

    private static File getDefaultDomain(File domainsDir) {
        File[] domains = domainsDir.listFiles(File::isDirectory);
        if (domains == null || domains.length == 0) {
            throw new RuntimeException("no domain directories found under " + domainsDir);
        }
        if (domains.length > 1) {
            throw new RuntimeException("Multiple domains[" + domains.length + "] found under " + domainsDir + " -- you must specify a domain name as -domain <name>");
        }
        return domains[0];
    }

    private static void verifyDomainRoot(File domainRoot) {
        if (domainRoot == null) {
            throw new RuntimeException("Internal Error: The domain dir is null.");
        }
        if (!domainRoot.exists()) {
            throw new RuntimeException("the domain directory does not exist");
        }
        if (!domainRoot.isDirectory()) {
            throw new RuntimeException("the domain directory is not a directory.");
        }
        if (!domainRoot.canWrite()) {
            throw new RuntimeException("the domain directory is not writable.");
        }
        if (!new File(domainRoot, "config").isDirectory()) {
            throw new RuntimeException("the domain directory is corrupt - there is no config subdirectory.");
        }
    }

    private static Properties createDefaultLoggingProperties() {
        Properties cfg = new Properties();
        cfg.setProperty("handlers", "org.glassfish.main.jul.handler.SimpleLogHandler,org.glassfish.main.jul.handler.GlassFishLogHandler");
        cfg.setProperty("org.glassfish.main.jul.handler.SimpleLogHandler.formatter", "org.glassfish.main.jul.formatter.UniformLogFormatter");
        if ("true".equals(System.getenv(ENV_AS_TRACE_LOGGING))) {
            cfg.setProperty("org.glassfish.main.jul.tracing.enabled", "true");
        }
        cfg.setProperty("systemRootLogger.level", Level.INFO.getName());
        cfg.setProperty(".level", Level.INFO.getName());
        if ("true".equals(System.getenv(ENV_AS_TRACE_BOOTSTRAP))) {
            cfg.setProperty("org.glassfish.main.jul.record.resolveLevelWithIncompleteConfiguration", "false");
        } else {
            cfg.setProperty("org.glassfish.main.jul.record.resolveLevelWithIncompleteConfiguration", "true");
        }
        return cfg;
    }

    private static String getParam(Properties map, String name) {
        String val = map.getProperty("-" + name);
        if (val == null) {
            val = map.getProperty("--" + name);
        }
        return val;
    }

    private static File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }

    private static boolean isSet(String s) {
        return s != null && !s.isEmpty();
    }
}

