/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.acl;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.Role;
import org.glassfish.security.common.UserNameAndPassword;
import org.glassfish.security.common.UserPrincipal;

public class RoleMapper
implements Serializable,
SecurityRoleMapper {
    private static final long serialVersionUID = -4455830942007736853L;
    private static final Logger LOG = LogDomains.getLogger(RoleMapper.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    private String appName;
    private final Map<String, Subject> roleToSubject = new HashMap<String, Subject>();
    private String defaultP2RMappingClassName;
    private final DefaultRoleToSubjectMapping defaultRTSM = new DefaultRoleToSubjectMapping();
    private final Map<String, Set<UserPrincipal>> roleToPrincipal = new HashMap<String, Set<UserPrincipal>>();
    private final Map<String, Set<Group>> roleToGroup = new HashMap<String, Set<Group>>();
    private Mapping currentMapping;
    private Set<Role> topLevelRoles;
    private static final String TOP_LEVEL = "sun-application.xml mapping file";
    private boolean conflictLogged;
    private Set<Role> conflictedRoles;
    private transient SecurityService secService;

    RoleMapper(String appName) {
        this.appName = appName;
        this.secService = (SecurityService)Globals.getDefaultHabitat().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
        this.defaultP2RMappingClassName = this.getDefaultP2RMappingClassName();
    }

    public String getName() {
        return this.appName;
    }

    public void setName(String name) {
        this.appName = name;
    }

    private void addRoleToPrincipal(final Principal principal, String role) {
        assert (this.roleToSubject != null);
        Subject subject = this.roleToSubject.get(role);
        final Subject sub = subject == null ? new Subject() : subject;
        AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sub.getPrincipals().add(principal);
                return null;
            }
        });
        this.roleToSubject.put(role, sub);
    }

    public void unassignPrincipalFromRole(Role role, Principal principal) {
        assert (this.roleToSubject != null);
        String mrole = role.getName();
        final Subject sub = this.roleToSubject.get(mrole);
        final Principal p = principal;
        if (sub != null) {
            AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    sub.getPrincipals().remove(p);
                    return null;
                }
            });
            this.roleToSubject.put(mrole, sub);
        }
        if (principal instanceof Group) {
            Set<Group> groups = this.roleToGroup.get(mrole);
            if (groups != null) {
                groups.remove(principal);
                this.roleToGroup.put(mrole, groups);
            }
        } else {
            Set<UserPrincipal> principals = this.roleToPrincipal.get(mrole);
            if (principals != null) {
                principals.remove(principal);
                this.roleToPrincipal.put(mrole, principals);
            }
        }
    }

    boolean isDefaultRTSMActivated() {
        return this.defaultP2RMappingClassName != null;
    }

    public Map<String, Subject> getRoleToSubjectMapping() {
        this.checkAndAddMappings();
        assert (this.roleToSubject != null);
        if (this.roleToSubject.isEmpty() && this.isDefaultRTSMActivated()) {
            return this.defaultRTSM;
        }
        return this.roleToSubject;
    }

    private void internalAssignRole(Principal p, Role r) {
        String role = r.getName();
        LOG.log(Level.FINE, "Assigning Role {0} to {1}", new Object[]{role, p});
        this.addRoleToPrincipal(p, role);
        if (p instanceof Group) {
            Set<Group> groups = this.roleToGroup.get(role);
            if (groups == null) {
                groups = new HashSet<Group>();
            }
            groups.add((Group)p);
            this.roleToGroup.put(role, groups);
        } else if (p instanceof UserPrincipal) {
            Set<UserPrincipal> principals = this.roleToPrincipal.get(role);
            if (principals == null) {
                principals = new HashSet<UserPrincipal>();
            }
            principals.add((UserPrincipal)p);
            this.roleToPrincipal.put(role, principals);
        } else {
            throw new IllegalArgumentException("Unknown principal class: " + p.getClass());
        }
    }

    public void assignRole(Principal p, Role r, RootDeploymentDescriptor rdd) {
        assert (rdd != null);
        String callingModuleID = this.getModuleID(rdd);
        if (this.currentMapping == null) {
            this.currentMapping = new Mapping(callingModuleID);
        } else if (!callingModuleID.equals(this.currentMapping.owner)) {
            this.checkAndAddMappings();
            this.currentMapping = new Mapping(callingModuleID);
        }
        if (callingModuleID.equals(TOP_LEVEL) && this.topLevelRoles == null) {
            this.topLevelRoles = new HashSet<Role>();
        }
        this.currentMapping.addMapping(p, r);
    }

    public Iterator<String> getRoles() {
        assert (this.roleToSubject != null);
        return this.roleToSubject.keySet().iterator();
    }

    public Enumeration<Group> getGroupsAssignedTo(Role r) {
        assert (this.roleToGroup != null);
        Set<Group> s = this.roleToGroup.get(r.getName());
        if (s == null) {
            return Collections.enumeration(Collections.emptySet());
        }
        return Collections.enumeration(s);
    }

    public Enumeration<UserPrincipal> getUsersAssignedTo(Role r) {
        assert (this.roleToPrincipal != null);
        Set<UserPrincipal> s = this.roleToPrincipal.get(r.getName());
        if (s == null) {
            return Collections.enumeration(Collections.emptySet());
        }
        return Collections.enumeration(s);
    }

    public void unassignRole(Role r) {
        if (r != null) {
            String role = r.getName();
            this.roleToSubject.remove(role);
            this.roleToPrincipal.remove(role);
            this.roleToGroup.remove(role);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("RoleMapper:");
        Iterator<String> e = this.getRoles();
        while (e.hasNext()) {
            String r = e.next();
            s.append("\n\tRole (").append(r).append(") has Principals(");
            Subject sub = this.roleToSubject.get(r);
            for (Principal p : sub.getPrincipals()) {
                s.append(p.getName()).append(" ");
            }
            s.append(")");
        }
        return s.toString();
    }

    public RoleMapper(RoleMapper r) {
        this.appName = r.getName();
        Iterator<String> it = r.getRoles();
        while (it.hasNext()) {
            String role = it.next();
            Enumeration<Group> groups = r.getGroupsAssignedTo(new Role(role));
            HashSet<Group> groupsToRole = new HashSet<Group>();
            while (groups.hasMoreElements()) {
                Group gp = groups.nextElement();
                groupsToRole.add(new Group(gp.getName()));
                this.addRoleToPrincipal((Principal)gp, role);
            }
            this.roleToGroup.put(role, groupsToRole);
            Enumeration<UserPrincipal> users = r.getUsersAssignedTo(new Role(role));
            HashSet<UserNameAndPassword> usersToRole = new HashSet<UserNameAndPassword>();
            while (users.hasMoreElements()) {
                UserPrincipal principal = users.nextElement();
                usersToRole.add(new UserNameAndPassword(principal.getName()));
                this.addRoleToPrincipal((Principal)principal, role);
            }
            this.roleToPrincipal.put(role, usersToRole);
        }
    }

    private String getDefaultP2RMappingClassName() {
        String className = null;
        try {
            if (this.secService != null && Boolean.parseBoolean(this.secService.getActivateDefaultPrincipalToRoleMapping()) && ((className = this.secService.getMappedPrincipalClass()) == null || className.isEmpty())) {
                className = Group.class.getName();
            }
            if (className == null) {
                return null;
            }
            Class<?> clazz = Class.forName(className);
            Constructor<?> c = clazz.getConstructor(String.class);
            c.newInstance("anystring");
            return className;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "pc.getDefaultP2RMappingClass: " + className, e);
            return null;
        }
    }

    private String getModuleID(RootDeploymentDescriptor rdd) {
        if (rdd.isApplication()) {
            return TOP_LEVEL;
        }
        if (rdd.getModuleDescriptor() != null) {
            return rdd.getModuleDescriptor().getArchiveUri();
        }
        throw new AssertionError((Object)(rdd.getClass() + " is not a known descriptor type"));
    }

    private void checkAndAddMappings() {
        if (this.currentMapping == null) {
            return;
        }
        for (Role r : this.currentMapping.getRoles()) {
            if (this.topLevelRoles != null && this.topLevelRoles.contains(r)) {
                this.logConflictWarning();
                LOG.log(Level.FINE, "Role {0} from module {1} is being overridden by top-level mapping.", new Object[]{r, this.currentMapping.owner});
                continue;
            }
            if (this.currentMapping.owner.equals(TOP_LEVEL)) {
                this.topLevelRoles.add(r);
                if (this.roleToSubject.keySet().contains(r.getName())) {
                    this.logConflictWarning();
                    LOG.log(Level.FINE, "Role {0} from top-level mapping descriptor is overriding existing role in sub module.", r);
                    this.unassignRole(r);
                }
            } else if (this.roleConflicts(r, this.currentMapping.getPrincipals(r))) {
                this.logConflictWarning();
                this.unassignRole(r);
                continue;
            }
            for (Principal p : this.currentMapping.getPrincipals(r)) {
                this.internalAssignRole(p, r);
            }
        }
        this.currentMapping = null;
    }

    private boolean roleConflicts(Role r, Set<Principal> ps) {
        if (this.conflictedRoles != null && this.conflictedRoles.contains(r)) {
            LOG.log(Level.FINE, "Role {0} from module {1} has already had a conflict with other modules.", new Object[]{r, this.currentMapping.owner});
            return true;
        }
        if (!this.roleToSubject.keySet().contains(r.getName())) {
            return false;
        }
        int targetNumPrin = ps.size();
        int actualNum = 0;
        Set<UserPrincipal> pSet = this.roleToPrincipal.get(r.getName());
        Set<Group> gSet = this.roleToGroup.get(r.getName());
        actualNum += pSet == null ? 0 : pSet.size();
        if (targetNumPrin != (actualNum += gSet == null ? 0 : gSet.size())) {
            LOG.log(Level.FINE, "Module {0} has different number of mappings for role {1} than other mapping files", new Object[]{this.currentMapping.owner, r.getName()});
            if (this.conflictedRoles == null) {
                this.conflictedRoles = new HashSet<Role>();
            }
            this.conflictedRoles.add(r);
            return true;
        }
        boolean fail = false;
        for (Principal p : ps) {
            if (p instanceof Group) {
                if (gSet != null && !gSet.contains(p)) {
                    fail = true;
                }
            } else if (pSet != null && !pSet.contains(p)) {
                fail = true;
            }
            if (!fail) continue;
            LOG.log(Level.FINE, "Role {0} in module {1} is not included in other modules.", new Object[]{r, this.currentMapping.owner});
            if (this.conflictedRoles == null) {
                this.conflictedRoles = new HashSet<Role>();
            }
            this.conflictedRoles.add(r);
            return true;
        }
        return false;
    }

    private void logConflictWarning() {
        if (!this.conflictLogged) {
            LOG.log(Level.WARNING, "Role mapping conflicts found in application {0}. Some roles may not be mapped.", this.getName());
            this.conflictLogged = true;
        }
    }

    class DefaultRoleToSubjectMapping
    extends HashMap<String, Subject> {
        private static final long serialVersionUID = 3074733840327132690L;
        private final HashMap<String, Subject> roleMap = new HashMap();

        DefaultRoleToSubjectMapping() {
        }

        Principal getSameNamedPrincipal(String roleName) {
            try {
                Class<?> clazz = Class.forName(RoleMapper.this.defaultP2RMappingClassName);
                Class[] argClasses = new Class[]{String.class};
                Object[] arg = new Object[]{roleName};
                Constructor<?> c = clazz.getConstructor(argClasses);
                Principal principal = (Principal)c.newInstance(arg);
                return principal;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get principal by default p2r mapping", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Subject get(Object key) {
            HashMap<String, Subject> hashMap = this.roleMap;
            synchronized (hashMap) {
                Subject s = this.roleMap.get(key);
                if (s == null && key instanceof String && !"**".equals(key)) {
                    final Subject fs = new Subject();
                    final String roleName = (String)key;
                    AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(){

                        @Override
                        public Void run() {
                            fs.getPrincipals().add(DefaultRoleToSubjectMapping.this.getSameNamedPrincipal(roleName));
                            return null;
                        }
                    });
                    this.roleMap.put((String)key, fs);
                    s = fs;
                }
                return s;
            }
        }
    }

    private static class Mapping
    implements Serializable {
        private static final long serialVersionUID = 5863982599500877228L;
        private final String owner;
        private final Map<Role, Set<Principal>> roleMap;

        Mapping(String owner) {
            this.owner = owner;
            this.roleMap = new HashMap<Role, Set<Principal>>();
        }

        void addMapping(Principal p, Role r) {
            Set<Principal> pSet = this.roleMap.get(r);
            if (pSet == null) {
                pSet = new HashSet<Principal>();
                this.roleMap.put(r, pSet);
            }
            pSet.add(p);
        }

        Set<Role> getRoles() {
            return this.roleMap.keySet();
        }

        Set<Principal> getPrincipals(Role r) {
            return this.roleMap.get(r);
        }
    }
}

