/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.manager.FacesSchema;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DbfFactory {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String SCHEMA_MAP = "com.sun.faces.config.schemaMap";
    public static final FacesEntityResolver FACES_ENTITY_RESOLVER = new FacesEntityResolver();
    public static final FacesErrorHandler FACES_ERROR_HANDLER = new FacesErrorHandler();

    public static DocumentBuilderFactory getFactory() {
        DocumentBuilderFactory factory = Util.createDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        return factory;
    }

    public static Schema getSchema(ServletContext servletContext, String documentNS, String version, String localName) {
        return DbfFactory.getSchema(servletContext, FacesSchema.fromDocumentId(documentNS, version, localName));
    }

    public static Schema getSchema(ServletContext servletContext, FacesSchema schemaId) {
        return DbfFactory.getSchemaMap(servletContext).computeIfAbsent(schemaId, e -> schemaId.loadSchema());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<FacesSchema, Schema> getSchemaMap(ServletContext servletContext) {
        Map schemaMap = (Map)servletContext.getAttribute(SCHEMA_MAP);
        if (schemaMap == null) {
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                schemaMap = Collections.synchronizedMap(new EnumMap(FacesSchema.class));
                servletContext.setAttribute(SCHEMA_MAP, schemaMap);
            }
        }
        return schemaMap;
    }

    public static void removeSchemaMap(ServletContext servletContext) {
        servletContext.removeAttribute(SCHEMA_MAP);
    }

    public static Schema loadSchema(String resourceName, String fileName) throws SAXException, IOException {
        URL url = DbfFactory.class.getResource(resourceName);
        if (url == null) {
            File schemaFile = new File(fileName);
            if (!schemaFile.exists()) {
                throw new IllegalStateException("Unable to find " + resourceName);
            }
            url = schemaFile.toURI().toURL();
        }
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(false);
        try (InputStream in = urlConnection.getInputStream();){
            SchemaFactory factory = Util.createSchemaFactory("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver(FACES_ENTITY_RESOLVER);
            Schema schema = factory.newSchema(new StreamSource(in));
            return schema;
        }
    }

    private static class FacesEntityResolver
    extends DefaultHandler
    implements LSResourceResolver {
        private HashMap<String, String> entities = new HashMap(12, 1.0f);

        public FacesEntityResolver() {
            for (String[] schemaInfo : FacesSchema.Schemas.DTD_SCHEMA_INFO) {
                URL schemaUrl = this.getClass().getResource(schemaInfo[1]);
                if (schemaUrl == null) {
                    File schemaFile;
                    String schemaPath;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "faces.config.cannot_resolve_entities", new Object[]{schemaInfo[1], schemaInfo[0]});
                    }
                    if ((schemaPath = schemaInfo[2]) == null || !(schemaFile = new File(schemaPath)).exists()) continue;
                    try {
                        schemaUrl = schemaFile.toURI().toURL();
                    }
                    catch (MalformedURLException mue) {
                        LOGGER.log(Level.SEVERE, mue, mue::toString);
                    }
                    if (schemaUrl == null) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, "faces.config.cannot_resolve_entities", new Object[]{schemaInfo[1], schemaInfo[2]});
                        continue;
                    }
                    this.entities.put(schemaInfo[0], schemaUrl.toString());
                    continue;
                }
                this.entities.put(schemaInfo[0], schemaUrl.toString());
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputSource source;
            if (systemId == null) {
                InputSource result;
                try {
                    result = super.resolveEntity(publicId, null);
                }
                catch (IOException | SAXException e) {
                    throw new SAXException(e);
                }
                return result;
            }
            String grammarName = systemId.substring(systemId.lastIndexOf(47) + 1);
            String entityURL = this.entities.get(grammarName);
            if (entityURL == null) {
                LOGGER.log(Level.FINE, "Unknown entity, deferring to superclass.");
                try {
                    source = super.resolveEntity(publicId, systemId);
                }
                catch (IOException | SAXException e) {
                    throw new SAXException(e);
                }
            }
            try {
                source = new InputSource(new URL(entityURL).openStream());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "faces.config.cannot_create_inputsource", entityURL);
                source = null;
            }
            if (source != null) {
                source.setSystemId(entityURL);
                if (publicId != null) {
                    source.setPublicId(publicId);
                }
            }
            return source;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                InputSource source = this.resolveEntity(publicId, systemId);
                if (source != null) {
                    return new Input(source.getByteStream());
                }
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            return null;
        }
    }

    private static class FacesErrorHandler
    implements ErrorHandler {
        private FacesErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    private static final class Input
    implements LSInput {
        InputStream in;

        public Input(InputStream in) {
            this.in = in;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return this.in;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }
}

