/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authorization.cache;

import com.sun.enterprise.security.ee.authorization.cache.PermissionCache;
import java.security.Permission;
import java.util.Hashtable;

public class PermissionCacheFactory {
    private static final Hashtable cacheMap = new Hashtable();
    private static int factoryKey = 0;
    private static boolean supportsReuse = false;

    private static Integer getNextKey() {
        Integer key = factoryKey++;
        while (cacheMap.get(key) != null) {
            key = factoryKey++;
        }
        return key;
    }

    public static synchronized PermissionCache createPermissionCache(String contextId, Permission[] perms, String name) {
        if (!supportsReuse) {
            return null;
        }
        return PermissionCacheFactory.registerPermissionCache(new PermissionCache(PermissionCacheFactory.getNextKey(), contextId, perms, name));
    }

    public static synchronized PermissionCache createPermissionCache(String contextId, Class<?> clazz, String name) {
        if (!supportsReuse) {
            return null;
        }
        return PermissionCacheFactory.registerPermissionCache(new PermissionCache(PermissionCacheFactory.getNextKey(), contextId, clazz, name));
    }

    private static PermissionCache registerPermissionCache(PermissionCache cache) {
        cacheMap.put(cache.getFactoryKey(), cache);
        return cache;
    }

    public static synchronized PermissionCache removePermissionCache(PermissionCache cache) {
        Object value;
        PermissionCache permissionCache = null;
        if (cache != null && (value = cacheMap.remove(cache.getFactoryKey())) != null && value instanceof PermissionCache) {
            permissionCache = (PermissionCache)value;
            permissionCache.reset();
        }
        return permissionCache;
    }

    public static synchronized void resetCaches() {
        supportsReuse = true;
        for (Object cache : cacheMap.values()) {
            if (!(cache instanceof PermissionCache)) continue;
            ((PermissionCache)cache).reset();
        }
    }
}

