/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyOrReplyMessage;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.MessageMediator;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ResponseWaitingRoom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.SystemException;

@Transport
public class ResponseWaitingRoomImpl
implements ResponseWaitingRoom {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private final Map<Integer, OutCallDesc> out_calls;
    private final ORB orb;
    private final Connection connection;

    public ResponseWaitingRoomImpl(ORB orb, Connection connection) {
        this.orb = orb;
        this.connection = connection;
        this.out_calls = Collections.synchronizedMap(new HashMap());
    }

    @Override
    @Transport
    public void registerWaiter(MessageMediator messageMediator) {
        this.display("messageMediator request ID", messageMediator.getRequestId());
        this.display("messageMediator operation name", messageMediator.getOperationName());
        Integer requestId = messageMediator.getRequestId();
        OutCallDesc call = new OutCallDesc();
        call.messageMediator = messageMediator;
        OutCallDesc exists = this.out_calls.put(requestId, call);
        if (exists != null) {
            wrapper.duplicateRequestIdsInResponseWaitingRoom(ORBUtility.operationNameAndRequestId(exists.messageMediator), ORBUtility.operationNameAndRequestId(messageMediator));
        }
    }

    @Override
    @Transport
    public void unregisterWaiter(MessageMediator mediator) {
        MessageMediator messageMediator = mediator;
        this.display("messageMediator request ID", messageMediator.getRequestId());
        this.display("messageMediator operation name", messageMediator.getOperationName());
        Integer requestId = messageMediator.getRequestId();
        this.out_calls.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public CDRInputObject waitForResponse(MessageMediator messageMediator) {
        CDRInputObject returnStream = null;
        this.display("messageMediator request ID", messageMediator.getRequestId());
        this.display("messageMediator operation name", messageMediator.getOperationName());
        Integer requestId = messageMediator.getRequestId();
        if (messageMediator.isOneWay()) {
            this.display("Oneway request: not waiting");
            return null;
        }
        OutCallDesc call = this.out_calls.get(requestId);
        if (call == null) {
            throw wrapper.nullOutCall();
        }
        long waitForResponseTimeout = this.orb.getORBData().getWaitForResponseTimeout() * 1000L * 1000L;
        try {
            call.lock.lock();
            while (call.inputObject == null && call.exception == null) {
                try {
                    this.display("Waiting for response...");
                    waitForResponseTimeout = call.condition.awaitNanos(waitForResponseTimeout);
                    if (call.inputObject != null || call.exception != null) continue;
                    if (waitForResponseTimeout > 0L) {
                        this.display("Spurious wakeup, continuing to wait for ", waitForResponseTimeout / 1000000L);
                        continue;
                    }
                    call.exception = wrapper.communicationsTimeoutWaitingForResponse(this.orb.getORBData().getWaitForResponseTimeout());
                    ORBUtility.pushEncVersionToThreadLocalState((byte)1);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (call.exception != null) {
                this.display("Exception from call", (Object)call.exception);
                throw call.exception;
            }
            returnStream = call.inputObject;
        }
        finally {
            call.lock.unlock();
        }
        if (returnStream != null) {
            returnStream.unmarshalHeader();
        }
        return returnStream;
    }

    @InfoMethod
    private void display(String msg) {
    }

    @InfoMethod
    private void display(String msg, int value) {
    }

    @InfoMethod
    private void display(String msg, Object value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void responseReceived(CDRInputObject is) {
        CDRInputObject inputObject = is;
        LocateReplyOrReplyMessage header = (LocateReplyOrReplyMessage)inputObject.getMessageHeader();
        this.display("requestId", header.getRequestId());
        this.display("header", header);
        OutCallDesc call = this.out_calls.get(header.getRequestId());
        if (call == null) {
            this.display("No waiter");
            return;
        }
        try {
            call.lock.lock();
            MessageMediator messageMediator = call.messageMediator;
            this.display("Notifying waiters");
            this.display("messageMediator request ID", messageMediator.getRequestId());
            this.display("messageMediator operation name", messageMediator.getOperationName());
            messageMediator.setReplyHeader(header);
            messageMediator.setInputObject(is);
            inputObject.setMessageMediator(messageMediator);
            call.inputObject = is;
            call.condition.signal();
        }
        finally {
            call.lock.unlock();
        }
    }

    @Override
    public int numberRegistered() {
        return this.out_calls.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void signalExceptionToAllWaiters(SystemException systemException) {
        Map<Integer, OutCallDesc> map = this.out_calls;
        synchronized (map) {
            for (OutCallDesc call : this.out_calls.values()) {
                try {
                    call.lock.lock();
                    call.messageMediator.cancelRequest();
                    call.inputObject = null;
                    call.exception = systemException;
                    call.condition.signal();
                }
                finally {
                    call.lock.unlock();
                }
            }
        }
    }

    @Override
    public MessageMediator getMessageMediator(int requestId) {
        OutCallDesc call = this.out_calls.get(requestId);
        if (call == null) {
            return null;
        }
        return call.messageMediator;
    }

    static final class OutCallDesc {
        MessageMediator messageMediator;
        SystemException exception;
        CDRInputObject inputObject;
        ReentrantLock lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();

        OutCallDesc() {
        }
    }
}

